/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Undefined;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.Beta;
import java.util.ArrayList;
import java.util.List;

@Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
public final class PartitionKeyBuilder {
    private final List<Object> partitionKeyValues = new ArrayList<Object>();

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKeyBuilder() {
    }

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKeyBuilder add(String value) {
        this.partitionKeyValues.add(value);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKeyBuilder add(double value) {
        this.partitionKeyValues.add(value);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKeyBuilder add(boolean value) {
        this.partitionKeyValues.add(value);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKeyBuilder addNullValue() {
        this.partitionKeyValues.add(null);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKeyBuilder addNoneValue() {
        this.partitionKeyValues.add(PartitionKey.NONE);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_16_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public PartitionKey build() {
        if (this.partitionKeyValues.size() == 0) {
            throw new IllegalArgumentException("No partition key value has been specified");
        }
        if (this.partitionKeyValues.size() == 1 && PartitionKey.NONE.equals(this.partitionKeyValues.get(0))) {
            return PartitionKey.NONE;
        }
        Object[] valueArray = new Object[this.partitionKeyValues.size()];
        for (int i = 0; i < this.partitionKeyValues.size(); ++i) {
            Object val = this.partitionKeyValues.get(i);
            valueArray[i] = PartitionKey.NONE.equals(val) ? Undefined.value() : val;
        }
        PartitionKeyInternal partitionKeyInternal = PartitionKeyInternal.fromObjectArray(valueArray, true);
        return new PartitionKey(partitionKeyInternal);
    }
}

