/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.batch.BatchExecUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CosmosBatchResponse {
    private final Map<String, String> responseHeaders;
    private final int statusCode;
    private final String errorMessage;
    private final List<CosmosBatchOperationResult> results;
    private final int subStatusCode;
    private final CosmosDiagnostics cosmosDiagnostics;

    CosmosBatchResponse(int statusCode, int subStatusCode, String errorMessage, Map<String, String> responseHeaders, CosmosDiagnostics cosmosDiagnostics) {
        Preconditions.checkNotNull(statusCode, "expected non-null statusCode");
        Preconditions.checkNotNull(responseHeaders, "expected non-null responseHeaders");
        this.statusCode = statusCode;
        this.subStatusCode = subStatusCode;
        this.errorMessage = errorMessage;
        this.responseHeaders = responseHeaders;
        this.cosmosDiagnostics = cosmosDiagnostics;
        this.results = new ArrayList<CosmosBatchOperationResult>();
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.cosmosDiagnostics;
    }

    public int size() {
        return this.results == null ? 0 : this.results.size();
    }

    public boolean isSuccessStatusCode() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    public String getActivityId() {
        return BatchExecUtils.getActivityId(this.responseHeaders);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public double getRequestCharge() {
        return BatchExecUtils.getRequestCharge(this.responseHeaders);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getSessionToken() {
        return BatchExecUtils.getSessionToken(this.responseHeaders);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Duration getRetryAfterDuration() {
        return BatchExecUtils.getRetryAfterDuration(this.responseHeaders);
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public List<CosmosBatchOperationResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public int getResponseLength() {
        return BatchExecUtils.getResponseLength(this.responseHeaders);
    }

    public Duration getDuration() {
        if (this.cosmosDiagnostics == null) {
            return Duration.ZERO;
        }
        return this.cosmosDiagnostics.getDuration();
    }

    void addAll(List<? extends CosmosBatchOperationResult> collection) {
        this.results.addAll(collection);
    }

    static {
        ImplementationBridgeHelpers.CosmosBatchResponseHelper.setCosmosBatchResponseAccessor(new ImplementationBridgeHelpers.CosmosBatchResponseHelper.CosmosBatchResponseAccessor(){

            @Override
            public List<CosmosBatchOperationResult> getResults(CosmosBatchResponse cosmosBatchResponse) {
                return cosmosBatchResponse.results;
            }
        });
    }
}

