/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.ImmutablePair;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.PartitionMapper;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class ParallelDocumentQueryExecutionContext<T extends Resource>
extends ParallelDocumentQueryExecutionContextBase<T> {
    private static final Logger logger = LoggerFactory.getLogger(ParallelDocumentQueryExecutionContext.class);
    private final CosmosQueryRequestOptions cosmosQueryRequestOptions;
    private final Map<FeedRangeEpkImpl, String> partitionKeyRangeToContinuationTokenMap;

    private ParallelDocumentQueryExecutionContext(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, String collectionRid, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, rewrittenQuery, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        this.cosmosQueryRequestOptions = cosmosQueryRequestOptions;
        this.partitionKeyRangeToContinuationTokenMap = new HashMap<FeedRangeEpkImpl, String>();
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams) {
        ParallelDocumentQueryExecutionContext<T> context = new ParallelDocumentQueryExecutionContext<T>(diagnosticsClientContext, client, initParams.getResourceTypeEnum(), initParams.getResourceType(), initParams.getQuery(), initParams.getCosmosQueryRequestOptions(), initParams.getResourceLink(), initParams.getQueryInfo().getRewrittenQuery(), initParams.getCollectionRid(), initParams.isContinuationExpected(), initParams.isGetLazyResponseFeed(), initParams.getCorrelatedActivityId());
        context.setTop(initParams.getTop());
        try {
            super.initialize(initParams.getCollectionRid(), initParams.getFeedRanges(), initParams.getInitialPageSize(), ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(initParams.getCosmosQueryRequestOptions()));
            return Flux.just(context);
        }
        catch (CosmosException dce) {
            return Flux.error((Throwable)((Object)dce));
        }
    }

    public static <T extends Resource> Flux<IDocumentQueryExecutionComponent<T>> createReadManyQueryAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String collectionRid, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        ParallelDocumentQueryExecutionContext<T> context = new ParallelDocumentQueryExecutionContext<T>(diagnosticsClientContext, queryClient, resourceTypeEnum, klass, sqlQuery, cosmosQueryRequestOptions, collectionLink, sqlQuery.getQueryText(), collectionRid, false, false, activityId);
        context.initializeReadMany(queryClient, collectionResourceId, sqlQuery, rangeQueryMap, cosmosQueryRequestOptions, activityId, collectionRid);
        return Flux.just(context);
    }

    private void initialize(String collectionRid, List<FeedRangeEpkImpl> feedRanges, int initialPageSize, String continuationToken) {
        if (continuationToken == null) {
            for (FeedRangeEpkImpl feedRangeEpk : feedRanges) {
                this.partitionKeyRangeToContinuationTokenMap.put(feedRangeEpk, null);
            }
        } else {
            Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken = new Utils.ValueHolder<CompositeContinuationToken>();
            if (!CompositeContinuationToken.tryParse(continuationToken, outCompositeContinuationToken)) {
                String message = String.format("INVALID JSON in continuation token %s for Parallel~Context", continuationToken);
                throw BridgeInternal.createCosmosException(400, message);
            }
            CompositeContinuationToken compositeContinuationToken = (CompositeContinuationToken)outCompositeContinuationToken.v;
            PartitionMapper.PartitionMapping<CompositeContinuationToken> partitionMapping = PartitionMapper.getPartitionMapping(feedRanges, Collections.singletonList(compositeContinuationToken));
            this.populatePartitionToContinuationMap(partitionMapping.getTargetMapping());
            this.populatePartitionToContinuationMap(partitionMapping.getMappingRightOfTarget());
        }
        super.initialize(collectionRid, this.partitionKeyRangeToContinuationTokenMap, initialPageSize, this.querySpec);
    }

    private void populatePartitionToContinuationMap(Map<FeedRangeEpkImpl, CompositeContinuationToken> partitionMapping) {
        for (Map.Entry<FeedRangeEpkImpl, CompositeContinuationToken> entry : partitionMapping.entrySet()) {
            if (entry.getValue() != null) {
                this.partitionKeyRangeToContinuationTokenMap.put(entry.getKey(), entry.getValue().getToken());
                continue;
            }
            this.partitionKeyRangeToContinuationTokenMap.put(entry.getKey(), null);
        }
    }

    static void logEmptyPageDiagnostics(CosmosDiagnostics cosmosDiagnostics, UUID correlatedActivityId, String activityId) {
        List<ClientSideRequestStatistics> requestStatistics = BridgeInternal.getClientSideRequestStatisticsList(cosmosDiagnostics);
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Empty page request diagnostics for correlatedActivityId [{}] - activityId [{}] - [{}]", new Object[]{correlatedActivityId, activityId, Utils.getSimpleObjectMapper().writeValueAsString(requestStatistics)});
            }
        }
        catch (JsonProcessingException e) {
            logger.warn("Failed to log empty page diagnostics. ", (Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<T>> drainAsync(int maxPageSize) {
        List obs = this.documentProducers.stream().sorted(Comparator.comparing(dp -> dp.feedRange.getRange().getMin())).map(DocumentProducer::produceAsync).collect(Collectors.toList());
        int fluxConcurrency = this.fluxSequentialMergeConcurrency(this.cosmosQueryRequestOptions, obs.size());
        int fluxPrefetch = this.fluxSequentialMergePrefetch(this.cosmosQueryRequestOptions, obs.size(), maxPageSize, fluxConcurrency);
        logger.debug("ParallelQuery: flux mergeSequential concurrency {}, prefetch {}", (Object)fluxConcurrency, (Object)fluxPrefetch);
        return Flux.mergeSequential(obs, (int)fluxConcurrency, (int)fluxPrefetch).transformDeferred(new EmptyPagesFilterTransformer(new RequestChargeTracker(), this.cosmosQueryRequestOptions, this.correlatedActivityId));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.drainAsync(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(this.cosmosQueryRequestOptions));
    }

    @Override
    protected DocumentProducer<T> createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, String initialContinuationToken, int initialPageSize, CosmosQueryRequestOptions cosmosQueryRequestOptions, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc, Callable<DocumentClientRetryPolicy> createRetryPolicyFunc, FeedRangeEpkImpl feedRange) {
        return new DocumentProducer<T>(this.client, collectionRid, cosmosQueryRequestOptions, createRequestFunc, executeFunc, targetRange, collectionRid, createRetryPolicyFunc, this.resourceType, this.correlatedActivityId, initialPageSize, initialContinuationToken, this.top, feedRange);
    }

    private int fluxSequentialMergeConcurrency(CosmosQueryRequestOptions options, int numberOfPartitions) {
        int parallelism = options.getMaxDegreeOfParallelism();
        if (parallelism < 0) {
            parallelism = Configs.getCPUCnt();
        } else if (parallelism == 0) {
            parallelism = 1;
        }
        return Math.min(numberOfPartitions, parallelism);
    }

    private int fluxSequentialMergePrefetch(CosmosQueryRequestOptions options, int numberOfPartitions, int pageSize, int fluxConcurrency) {
        int maxBufferedItemCount = options.getMaxBufferedItemCount();
        if (maxBufferedItemCount <= 0) {
            maxBufferedItemCount = Math.min(Configs.getCPUCnt() * numberOfPartitions * pageSize, 100000);
        }
        int fluxPrefetch = Math.max(maxBufferedItemCount / Math.max(fluxConcurrency * pageSize, 1), 1);
        return Math.min(fluxPrefetch, Queues.XS_BUFFER_SIZE);
    }

    private static class EmptyPagesFilterTransformer<T extends Resource>
    implements Function<Flux<DocumentProducer.DocumentProducerFeedResponse>, Flux<FeedResponse<T>>> {
        private final RequestChargeTracker tracker;
        private DocumentProducer.DocumentProducerFeedResponse previousPage;
        private final CosmosQueryRequestOptions cosmosQueryRequestOptions;
        private final UUID correlatedActivityId;
        private ConcurrentMap<String, QueryMetrics> emptyPageQueryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>();
        private CosmosDiagnostics cosmosDiagnostics;

        public EmptyPagesFilterTransformer(RequestChargeTracker tracker, CosmosQueryRequestOptions options, UUID correlatedActivityId) {
            if (tracker == null) {
                throw new IllegalArgumentException("Request Charge Tracker must not be null.");
            }
            this.tracker = tracker;
            this.previousPage = null;
            this.cosmosQueryRequestOptions = options;
            this.correlatedActivityId = correlatedActivityId;
        }

        private DocumentProducer.DocumentProducerFeedResponse plusCharge(DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse, double charge) {
            FeedResponse page = documentProducerFeedResponse.pageResult;
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            double pageCharge = page.getRequestCharge();
            headers.put("x-ms-request-charge", String.valueOf(pageCharge += charge));
            FeedResponse newPage = BridgeInternal.createFeedResponseWithQueryMetrics(page.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(page), ModelBridgeInternal.getQueryPlanDiagnosticsContext(page), false, false, page.getCosmosDiagnostics());
            documentProducerFeedResponse.pageResult = newPage;
            return documentProducerFeedResponse;
        }

        private DocumentProducer.DocumentProducerFeedResponse addCompositeContinuationToken(DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse, String compositeContinuationToken) {
            FeedResponse page = documentProducerFeedResponse.pageResult;
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            headers.put("x-ms-continuation", compositeContinuationToken);
            FeedResponse newPage = BridgeInternal.createFeedResponseWithQueryMetrics(page.getResults(), headers, BridgeInternal.queryMetricsFromFeedResponse(page), ModelBridgeInternal.getQueryPlanDiagnosticsContext(page), false, false, page.getCosmosDiagnostics());
            documentProducerFeedResponse.pageResult = newPage;
            return documentProducerFeedResponse;
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        }

        @Override
        public Flux<FeedResponse<T>> apply(Flux<DocumentProducer.DocumentProducerFeedResponse> source) {
            return source.filter(documentProducerFeedResponse -> {
                if (documentProducerFeedResponse.pageResult.getResults().isEmpty() && !ModelBridgeInternal.getEmptyPagesAllowedFromQueryRequestOptions(this.cosmosQueryRequestOptions)) {
                    this.tracker.addCharge(documentProducerFeedResponse.pageResult.getRequestCharge());
                    ConcurrentMap<String, QueryMetrics> currentQueryMetrics = BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult);
                    QueryMetrics.mergeQueryMetricsMap(this.emptyPageQueryMetricsMap, currentQueryMetrics);
                    this.cosmosDiagnostics = documentProducerFeedResponse.pageResult.getCosmosDiagnostics();
                    if (ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().isEmptyPageDiagnosticsEnabled(this.cosmosQueryRequestOptions)) {
                        ParallelDocumentQueryExecutionContext.logEmptyPageDiagnostics(this.cosmosDiagnostics, this.correlatedActivityId, documentProducerFeedResponse.pageResult.getActivityId());
                    }
                    return false;
                }
                return true;
            }).map(documentProducerFeedResponse -> {
                double charge;
                if (!this.emptyPageQueryMetricsMap.isEmpty()) {
                    ConcurrentMap<String, QueryMetrics> currentQueryMetrics = BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult);
                    QueryMetrics.mergeQueryMetricsMap(currentQueryMetrics, this.emptyPageQueryMetricsMap);
                    this.emptyPageQueryMetricsMap.clear();
                }
                if ((charge = this.tracker.getAndResetCharge()) > 0.0) {
                    return new Utils.ValueHolder<DocumentProducer.DocumentProducerFeedResponse>(this.plusCharge((DocumentProducer.DocumentProducerFeedResponse)documentProducerFeedResponse, charge));
                }
                return new Utils.ValueHolder<DocumentProducer.DocumentProducerFeedResponse>((DocumentProducer.DocumentProducerFeedResponse)documentProducerFeedResponse);
            }).concatWith((Publisher)Flux.just(new Utils.ValueHolder<Object>(null))).map(heldValue -> {
                DocumentProducer.DocumentProducerFeedResponse documentProducerFeedResponse = (DocumentProducer.DocumentProducerFeedResponse)heldValue.v;
                ImmutablePair<DocumentProducer.DocumentProducerFeedResponse, DocumentProducer.DocumentProducerFeedResponse> previousCurrent = new ImmutablePair<DocumentProducer.DocumentProducerFeedResponse, DocumentProducer.DocumentProducerFeedResponse>(this.previousPage, documentProducerFeedResponse);
                this.previousPage = documentProducerFeedResponse;
                return previousCurrent;
            }).skip(1L).map(currentNext -> {
                CompositeContinuationToken compositeContinuationTokenDom;
                String compositeContinuationToken;
                DocumentProducer.DocumentProducerFeedResponse current = (DocumentProducer.DocumentProducerFeedResponse)currentNext.left;
                DocumentProducer.DocumentProducerFeedResponse next = (DocumentProducer.DocumentProducerFeedResponse)currentNext.right;
                String backendContinuationToken = current.pageResult.getContinuationToken();
                if (backendContinuationToken == null) {
                    if (next == null) {
                        compositeContinuationToken = null;
                    } else {
                        compositeContinuationTokenDom = new CompositeContinuationToken(null, next.sourceFeedRange.getRange());
                        compositeContinuationToken = compositeContinuationTokenDom.toJson();
                    }
                } else {
                    compositeContinuationTokenDom = new CompositeContinuationToken(backendContinuationToken, current.sourceFeedRange.getRange());
                    compositeContinuationToken = compositeContinuationTokenDom.toJson();
                }
                DocumentProducer.DocumentProducerFeedResponse page = current;
                page = this.addCompositeContinuationToken(page, compositeContinuationToken);
                return page;
            }).map(documentProducerFeedResponse -> documentProducerFeedResponse.pageResult).switchIfEmpty((Publisher)Flux.defer(() -> Flux.just(BridgeInternal.createFeedResponseWithQueryMetrics(Utils.immutableListOf(), EmptyPagesFilterTransformer.headerResponse(this.tracker.getAndResetCharge()), this.emptyPageQueryMetricsMap, null, false, false, this.cosmosDiagnostics))));
        }
    }
}

