/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionEvent;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RntbdConnectionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(RntbdConnectionStateListener.class);
    private final IAddressResolver addressResolver;
    private final RntbdEndpoint endpoint;

    public RntbdConnectionStateListener(IAddressResolver addressResolver, RntbdEndpoint endpoint) {
        this.addressResolver = Preconditions.checkNotNull(addressResolver, "expected non-null addressResolver");
        this.endpoint = Preconditions.checkNotNull(endpoint, "expected non-null endpoint");
    }

    public void onException(RxDocumentServiceRequest request, Throwable exception) {
        Throwable cause;
        Preconditions.checkNotNull(request, "expect non-null request");
        Preconditions.checkNotNull(exception, "expect non-null exception");
        if (exception instanceof GoneException && (cause = exception.getCause()) != null && cause instanceof IOException) {
            if (cause instanceof ClosedChannelException) {
                this.onConnectionEvent(RntbdConnectionEvent.READ_EOF, request, exception);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Will not raise the connection state change event for error {}", cause);
            }
        }
    }

    private void onConnectionEvent(RntbdConnectionEvent event, RxDocumentServiceRequest request, Throwable exception) {
        Preconditions.checkNotNull(request, "expected non-null request");
        Preconditions.checkNotNull(exception, "expected non-null exception");
        if (event == RntbdConnectionEvent.READ_EOF) {
            if (!this.endpoint.isClosed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("onConnectionEvent({\"event\":{},\"time\":{},\"endpoint\":{},\"cause\":{})", new Object[]{event, RntbdObjectMapper.toJson(Instant.now()), RntbdObjectMapper.toJson(this.endpoint), RntbdObjectMapper.toJson(exception)});
                }
                this.addressResolver.updateAddresses(request, this.endpoint.serverKey());
            } else {
                logger.warn("Endpoint closed while onConnectionEvent: {}", (Object)this.endpoint);
            }
        }
    }
}

