/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.SessionContainer;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.HttpTransportClient;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.SharedTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;

public class StoreClientFactory
implements AutoCloseable {
    private final Configs configs;
    private final TransportClient transportClient;
    private volatile boolean isClosed;
    private final ClientTelemetry clientTelemetry;

    public StoreClientFactory(IAddressResolver addressResolver, DiagnosticsClientContext.DiagnosticsClientConfig diagnosticsClientConfig, Configs configs, ConnectionPolicy connectionPolicy, UserAgentContainer userAgent, boolean enableTransportClientSharing, ClientTelemetry clientTelemetry) {
        this.configs = configs;
        this.clientTelemetry = clientTelemetry;
        Protocol protocol = configs.getProtocol();
        if (enableTransportClientSharing) {
            this.transportClient = SharedTransportClient.getOrCreateInstance(protocol, configs, connectionPolicy, userAgent, diagnosticsClientConfig, addressResolver, clientTelemetry);
        } else if (protocol == Protocol.HTTPS) {
            this.transportClient = new HttpTransportClient(configs, connectionPolicy, userAgent);
        } else if (protocol == Protocol.TCP) {
            RntbdTransportClient.Options rntbdOptions = new RntbdTransportClient.Options.Builder(connectionPolicy).userAgent(userAgent).build();
            this.transportClient = new RntbdTransportClient(rntbdOptions, configs.getSslContext(), addressResolver, clientTelemetry);
            diagnosticsClientConfig.withRntbdOptions(rntbdOptions);
        } else {
            throw new IllegalArgumentException(String.format("protocol: %s", new Object[]{protocol}));
        }
    }

    @Override
    public void close() throws Exception {
        this.transportClient.close();
        this.isClosed = true;
    }

    public StoreClient createStoreClient(DiagnosticsClientContext diagnosticsClientContext, IAddressResolver addressResolver, SessionContainer sessionContainer, GatewayServiceConfigurationReader serviceConfigurationReader, IAuthorizationTokenProvider authorizationTokenProvider, boolean useMultipleWriteLocations) {
        this.throwIfClosed();
        return new StoreClient(diagnosticsClientContext, this.configs, addressResolver, sessionContainer, serviceConfigurationReader, authorizationTokenProvider, this.transportClient, useMultipleWriteLocations);
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("storeClient already closed!");
        }
    }
}

