/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.Quadruple;
import com.azure.cosmos.implementation.ReplicatedResourceClientUtils;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.directconnectivity.AddressSelector;
import com.azure.cosmos.implementation.directconnectivity.ConsistencyReader;
import com.azure.cosmos.implementation.directconnectivity.ConsistencyWriter;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.GoneAndRetryWithRetryPolicy;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TimeoutHelper;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReplicatedResourceClient {
    private final DiagnosticsClientContext diagnosticsClientContext;
    private final Logger logger = LoggerFactory.getLogger(ReplicatedResourceClient.class);
    private static final int GONE_AND_RETRY_WITH_TIMEOUT_IN_SECONDS = 30;
    private static final int STRONG_GONE_AND_RETRY_WITH_RETRY_TIMEOUT_SECONDS = 60;
    private static final int MIN_BACKOFF_FOR_FAILLING_BACK_TO_OTHER_REGIONS_FOR_READ_REQUESTS_IN_SECONDS = 1;
    private final AddressSelector addressSelector;
    private final ConsistencyReader consistencyReader;
    private final ConsistencyWriter consistencyWriter;
    private final Protocol protocol;
    private final TransportClient transportClient;
    private final boolean enableReadRequestsFallback;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private final Configs configs;

    public ReplicatedResourceClient(DiagnosticsClientContext diagnosticsClientContext, Configs configs, AddressSelector addressSelector, ISessionContainer sessionContainer, TransportClient transportClient, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider, boolean enableReadRequestsFallback, boolean useMultipleWriteLocations) {
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.configs = configs;
        this.protocol = configs.getProtocol();
        this.addressSelector = addressSelector;
        if (this.protocol != Protocol.HTTPS && this.protocol != Protocol.TCP) {
            throw new IllegalArgumentException("protocol");
        }
        this.transportClient = transportClient;
        this.serviceConfigReader = serviceConfigReader;
        this.consistencyReader = new ConsistencyReader(diagnosticsClientContext, configs, this.addressSelector, sessionContainer, transportClient, serviceConfigReader, authorizationTokenProvider);
        this.consistencyWriter = new ConsistencyWriter(diagnosticsClientContext, this.addressSelector, sessionContainer, transportClient, authorizationTokenProvider, serviceConfigReader, useMultipleWriteLocations);
        this.enableReadRequestsFallback = enableReadRequestsFallback;
    }

    public void enableThroughputControl(ThroughputControlStore throughputControlStore) {
        this.transportClient.enableThroughputControl(throughputControlStore);
    }

    public static boolean isReadingFromMaster(ResourceType resourceType, OperationType operationType) {
        return ReplicatedResourceClientUtils.isReadingFromMaster(resourceType, operationType);
    }

    public static boolean isMasterResource(ResourceType resourceType) {
        return ReplicatedResourceClientUtils.isMasterResource(resourceType);
    }

    public static boolean isGlobalStrongEnabled() {
        return true;
    }

    public Mono<StoreResponse> invokeAsync(RxDocumentServiceRequest request, Function<RxDocumentServiceRequest, Mono<RxDocumentServiceRequest>> prepareRequestAsyncDelegate) {
        BiFunction<Quadruple, RxDocumentServiceRequest, Mono> mainFuncDelegate = (forceRefreshAndTimeout, documentServiceRequest) -> {
            documentServiceRequest.getHeaders().put("x-ms-client-retry-attempt-count", ((Integer)forceRefreshAndTimeout.getValue3()).toString());
            documentServiceRequest.getHeaders().put("x-ms-remaining-time-in-ms-on-client", Long.toString(((Duration)forceRefreshAndTimeout.getValue2()).toMillis()));
            return this.invokeAsync(request, new TimeoutHelper((Duration)forceRefreshAndTimeout.getValue2()), (Boolean)forceRefreshAndTimeout.getValue1(), (Boolean)forceRefreshAndTimeout.getValue0());
        };
        Function funcDelegate = forceRefreshAndTimeout -> {
            if (prepareRequestAsyncDelegate != null) {
                return ((Mono)prepareRequestAsyncDelegate.apply(request)).flatMap(responseReq -> (Mono)mainFuncDelegate.apply((Quadruple)forceRefreshAndTimeout, (RxDocumentServiceRequest)responseReq));
            }
            return (Mono)mainFuncDelegate.apply((Quadruple)forceRefreshAndTimeout, request);
        };
        Function inBackoffFuncDelegate = null;
        if (request.isReadOnlyRequest() && this.enableReadRequestsFallback) {
            if (request.requestContext.cosmosDiagnostics == null) {
                request.requestContext.cosmosDiagnostics = request.createCosmosDiagnostics();
            }
            RxDocumentServiceRequest freshRequest = request.clone();
            inBackoffFuncDelegate = forceRefreshAndTimeout -> {
                RxDocumentServiceRequest readRequestClone = freshRequest.clone();
                if (prepareRequestAsyncDelegate != null) {
                    return ((Mono)prepareRequestAsyncDelegate.apply(readRequestClone)).flatMap(responseReq -> {
                        this.logger.trace("Executing inBackoffAlternateCallbackMethod on readRegionIndex {}", forceRefreshAndTimeout.getValue3());
                        responseReq.requestContext.routeToLocation((Integer)forceRefreshAndTimeout.getValue3(), true);
                        return this.invokeAsync((RxDocumentServiceRequest)responseReq, new TimeoutHelper((Duration)forceRefreshAndTimeout.getValue2()), (Boolean)forceRefreshAndTimeout.getValue1(), (Boolean)forceRefreshAndTimeout.getValue0());
                    });
                }
                this.logger.trace("Executing inBackoffAlternateCallbackMethod on readRegionIndex {}", forceRefreshAndTimeout.getValue3());
                readRequestClone.requestContext.routeToLocation((Integer)forceRefreshAndTimeout.getValue3(), true);
                return this.invokeAsync(readRequestClone, new TimeoutHelper((Duration)forceRefreshAndTimeout.getValue2()), (Boolean)forceRefreshAndTimeout.getValue1(), (Boolean)forceRefreshAndTimeout.getValue0());
            };
        }
        int retryTimeout = this.serviceConfigReader.getDefaultConsistencyLevel() == ConsistencyLevel.STRONG ? 60 : 30;
        return BackoffRetryUtility.executeAsync(funcDelegate, new GoneAndRetryWithRetryPolicy(request, retryTimeout), inBackoffFuncDelegate, Duration.ofSeconds(1L), request, this.addressSelector);
    }

    private Mono<StoreResponse> invokeAsync(RxDocumentServiceRequest request, TimeoutHelper timeout, boolean isInRetry, boolean forceRefresh) {
        if (request.getOperationType().equals((Object)OperationType.ExecuteJavaScript)) {
            if (request.isReadOnlyScript()) {
                return this.consistencyReader.readAsync(request, timeout, isInRetry, forceRefresh);
            }
            return this.consistencyWriter.writeAsync(request, timeout, forceRefresh);
        }
        if (request.getOperationType().isWriteOperation()) {
            return this.consistencyWriter.writeAsync(request, timeout, forceRefresh);
        }
        if (request.isReadOnlyRequest()) {
            return this.consistencyReader.readAsync(request, timeout, isInRetry, forceRefresh);
        }
        throw new IllegalArgumentException(String.format("Unexpected operation type %s", new Object[]{request.getOperationType()}));
    }
}

