/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetrySerializer;
import com.azure.cosmos.implementation.clienttelemetry.ReportPayload;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.HdrHistogram.ConcurrentDoubleHistogram;

@JsonSerialize(using=ClientTelemetrySerializer.class)
public class ClientTelemetryInfo {
    private String timeStamp;
    private String clientId;
    private String processId;
    private String userAgent;
    private ConnectionMode connectionMode;
    private String globalDatabaseAccountName;
    private String applicationRegion;
    private String hostEnvInfo;
    private Boolean acceleratedNetworking;
    private int aggregationIntervalInSec;
    private List<String> preferredRegions;
    private Map<ReportPayload, ConcurrentDoubleHistogram> systemInfoMap;
    private Map<ReportPayload, ConcurrentDoubleHistogram> cacheRefreshInfoMap;
    private Map<ReportPayload, ConcurrentDoubleHistogram> operationInfoMap;

    public ClientTelemetryInfo(String clientId, String processId, String userAgent, ConnectionMode connectionMode, String globalDatabaseAccountName, String applicationRegion, String hostEnvInfo, Boolean acceleratedNetworking, List<String> preferredRegions) {
        this.clientId = clientId;
        this.processId = processId;
        this.userAgent = userAgent;
        this.connectionMode = connectionMode;
        this.globalDatabaseAccountName = globalDatabaseAccountName;
        this.applicationRegion = applicationRegion;
        this.hostEnvInfo = hostEnvInfo;
        this.acceleratedNetworking = acceleratedNetworking;
        this.systemInfoMap = new ConcurrentHashMap<ReportPayload, ConcurrentDoubleHistogram>();
        this.cacheRefreshInfoMap = new ConcurrentHashMap<ReportPayload, ConcurrentDoubleHistogram>();
        this.operationInfoMap = new ConcurrentHashMap<ReportPayload, ConcurrentDoubleHistogram>();
        this.aggregationIntervalInSec = Configs.getClientTelemetrySchedulingInSec();
        this.preferredRegions = preferredRegions;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public void setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
    }

    public String getGlobalDatabaseAccountName() {
        return this.globalDatabaseAccountName;
    }

    public void setGlobalDatabaseAccountName(String globalDatabaseAccountName) {
        this.globalDatabaseAccountName = globalDatabaseAccountName;
    }

    public String getApplicationRegion() {
        return this.applicationRegion;
    }

    public void setApplicationRegion(String applicationRegion) {
        this.applicationRegion = applicationRegion;
    }

    public String getHostEnvInfo() {
        return this.hostEnvInfo;
    }

    public void setHostEnvInfo(String hostEnvInfo) {
        this.hostEnvInfo = hostEnvInfo;
    }

    public Boolean getAcceleratedNetworking() {
        return this.acceleratedNetworking;
    }

    public void setAcceleratedNetworking(Boolean acceleratedNetworking) {
        this.acceleratedNetworking = acceleratedNetworking;
    }

    public int getAggregationIntervalInSec() {
        return this.aggregationIntervalInSec;
    }

    public void setAggregationIntervalInSec(int aggregationIntervalInSec) {
        this.aggregationIntervalInSec = aggregationIntervalInSec;
    }

    public List<String> getPreferredRegions() {
        return this.preferredRegions;
    }

    public void setPreferredRegions(List<String> preferredRegions) {
        this.preferredRegions = preferredRegions;
    }

    public Map<ReportPayload, ConcurrentDoubleHistogram> getSystemInfoMap() {
        return this.systemInfoMap;
    }

    public void setSystemInfoMap(Map<ReportPayload, ConcurrentDoubleHistogram> systemInfoMap) {
        this.systemInfoMap = systemInfoMap;
    }

    public Map<ReportPayload, ConcurrentDoubleHistogram> getCacheRefreshInfoMap() {
        return this.cacheRefreshInfoMap;
    }

    public void setCacheRefreshInfoMap(Map<ReportPayload, ConcurrentDoubleHistogram> cacheRefreshInfoMap) {
        this.cacheRefreshInfoMap = cacheRefreshInfoMap;
    }

    public Map<ReportPayload, ConcurrentDoubleHistogram> getOperationInfoMap() {
        return this.operationInfoMap;
    }

    public void setOperationInfoMap(Map<ReportPayload, ConcurrentDoubleHistogram> operationInfoMap) {
        this.operationInfoMap = operationInfoMap;
    }
}

