/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.apachecommons.lang.time;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.Validate;
import java.util.ArrayList;

public class DurationFormatUtils {
    private static final Object y = "y";
    private static final Object M = "M";
    private static final Object d = "d";
    private static final Object H = "H";
    private static final Object m = "m";
    private static final Object s = "s";
    private static final Object S = "S";

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "HH:mm:ss.SSS", true);
    }

    private static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, durationMillis, "durationMillis must not be negative");
        Token[] tokens = DurationFormatUtils.lexx(format);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long milliseconds = durationMillis;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = milliseconds / 86400000L;
            milliseconds -= days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = milliseconds / 3600000L;
            milliseconds -= hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = milliseconds / 60000L;
            milliseconds -= minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = milliseconds / 1000L;
            milliseconds -= seconds * 1000L;
        }
        return DurationFormatUtils.format(tokens, 0L, 0L, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    private static String format(Token[] tokens, long years, long months, long days, long hours, long minutes, long seconds, long milliseconds, boolean padWithZeros) {
        StringBuilder buffer = new StringBuilder();
        boolean lastOutputSeconds = false;
        for (Token token : tokens) {
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuilder) {
                buffer.append(value.toString());
                continue;
            }
            if (value.equals(y)) {
                buffer.append(DurationFormatUtils.paddedValue(years, padWithZeros, count));
                lastOutputSeconds = false;
                continue;
            }
            if (value.equals(M)) {
                buffer.append(DurationFormatUtils.paddedValue(months, padWithZeros, count));
                lastOutputSeconds = false;
                continue;
            }
            if (value.equals(d)) {
                buffer.append(DurationFormatUtils.paddedValue(days, padWithZeros, count));
                lastOutputSeconds = false;
                continue;
            }
            if (value.equals(H)) {
                buffer.append(DurationFormatUtils.paddedValue(hours, padWithZeros, count));
                lastOutputSeconds = false;
                continue;
            }
            if (value.equals(m)) {
                buffer.append(DurationFormatUtils.paddedValue(minutes, padWithZeros, count));
                lastOutputSeconds = false;
                continue;
            }
            if (value.equals(s)) {
                buffer.append(DurationFormatUtils.paddedValue(seconds, padWithZeros, count));
                lastOutputSeconds = true;
                continue;
            }
            if (!value.equals(S)) continue;
            if (lastOutputSeconds) {
                int width = padWithZeros ? Math.max(3, count) : 3;
                buffer.append(DurationFormatUtils.paddedValue(milliseconds, true, width));
            } else {
                buffer.append(DurationFormatUtils.paddedValue(milliseconds, padWithZeros, count));
            }
            lastOutputSeconds = false;
        }
        return buffer.toString();
    }

    private static String paddedValue(long value, boolean padWithZeros, int count) {
        String longString = Long.toString(value);
        return padWithZeros ? StringUtils.leftPad(longString, count, '0') : longString;
    }

    private static Token[] lexx(String format) {
        ArrayList<Token> list = new ArrayList<Token>(format.length());
        boolean inLiteral = false;
        StringBuilder buffer = null;
        Token previous = null;
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuilder();
                    list.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        list.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue().equals(value)) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list.add(token);
                previous = token;
            }
            buffer = null;
        }
        if (inLiteral) {
            throw new IllegalArgumentException("Unmatched quote in format: " + format);
        }
        return list.toArray(new Token[list.size()]);
    }

    private static class DateUtils {
        public static final long MILLIS_PER_SECOND = 1000L;
        public static final long MILLIS_PER_MINUTE = 60000L;
        public static final long MILLIS_PER_HOUR = 3600000L;
        public static final long MILLIS_PER_DAY = 86400000L;

        private DateUtils() {
        }
    }

    private static class Token {
        private final Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            for (Token token : tokens) {
                if (token.getValue() != value) continue;
                return true;
            }
            return false;
        }

        Token(Object value) {
            this.value = value;
            this.count = 1;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

