/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.controller.request;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.throughputControl.ThroughputRequestThrottler;
import com.azure.cosmos.implementation.throughputControl.controller.request.IThroughputRequestController;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class GlobalThroughputRequestController
implements IThroughputRequestController {
    private final AtomicReference<Double> scheduledThroughput;
    private final ThroughputRequestThrottler requestThrottler;

    public GlobalThroughputRequestController(double initialScheduledThroughput) {
        this.scheduledThroughput = new AtomicReference<Double>(initialScheduledThroughput);
        this.requestThrottler = new ThroughputRequestThrottler(this.scheduledThroughput.get());
    }

    @Override
    public <T> Mono<T> init() {
        return Mono.just((Object)this.requestThrottler);
    }

    @Override
    public boolean canHandleRequest(RxDocumentServiceRequest request) {
        return true;
    }

    @Override
    public <T> Mono<T> processRequest(RxDocumentServiceRequest request, Mono<T> originalRequestMono) {
        return this.requestThrottler.processRequest(request, originalRequestMono);
    }

    @Override
    public double renewThroughputUsageCycle(double throughput) {
        this.scheduledThroughput.set(throughput);
        return this.requestThrottler.renewThroughputUsageCycle(throughput);
    }
}

