/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.QueryFeature;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.HashMap;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class QueryPlanRetriever {
    private static final String TRUE = "True";
    private static final String SUPPORTED_QUERY_FEATURES = QueryFeature.Aggregate.name() + ", " + QueryFeature.CompositeAggregate.name() + ", " + QueryFeature.MultipleOrderBy.name() + ", " + QueryFeature.MultipleAggregates.name() + ", " + QueryFeature.OrderBy.name() + ", " + QueryFeature.OffsetAndLimit.name() + ", " + QueryFeature.Distinct.name() + ", " + QueryFeature.GroupBy.name() + ", " + QueryFeature.Top.name() + ", " + QueryFeature.NonValueAggregate.name();

    QueryPlanRetriever() {
    }

    static Mono<PartitionedQueryExecutionInfo> getQueryPlanThroughGatewayAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, SqlQuerySpec sqlQuerySpec, String resourceLink, PartitionKey partitionKey) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        requestHeaders.put("x-ms-cosmos-is-query-plan-request", TRUE);
        requestHeaders.put("x-ms-cosmos-supported-query-features", SUPPORTED_QUERY_FEATURES);
        requestHeaders.put("x-ms-cosmos-query-version", "1.0");
        if (partitionKey != null && partitionKey != PartitionKey.NONE) {
            PartitionKeyInternal partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(partitionKey);
            requestHeaders.put("x-ms-documentdb-partitionkey", partitionKeyInternal.toJson());
        }
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(diagnosticsClientContext, OperationType.QueryPlan, ResourceType.Document, resourceLink, requestHeaders);
        request.UseGatewayMode = true;
        request.setByteBuffer(ModelBridgeInternal.serializeJsonToByteBuffer(sqlQuerySpec));
        DocumentClientRetryPolicy retryPolicyInstance = queryClient.getResetSessionTokenRetryPolicy().getRequestPolicy();
        Function<RxDocumentServiceRequest, Mono> executeFunc = req -> BackoffRetryUtility.executeRetry(() -> {
            retryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            return queryClient.executeQueryAsync(request).flatMap(rxDocumentServiceResponse -> {
                PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo(rxDocumentServiceResponse.getResponseBodyAsByteArray());
                return Mono.just((Object)partitionedQueryExecutionInfo);
            });
        }, retryPolicyInstance);
        return executeFunc.apply(request);
    }
}

