/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResult {
    private static final Logger logger = LoggerFactory.getLogger(StoreResult.class);
    private final StoreResponse storeResponse;
    private final CosmosException exception;
    public final long lsn;
    public final String partitionKeyRangeId;
    public final long quorumAckedLSN;
    public final long globalCommittedLSN;
    public final long numberOfReadRegions;
    public final long itemLSN;
    public final ISessionToken sessionToken;
    public final double requestCharge;
    public final int currentReplicaSetSize;
    public final int currentWriteQuorum;
    public final boolean isValid;
    public final boolean isGoneException;
    public final boolean isNotFoundException;
    public final boolean isInvalidPartitionException;
    public final Uri storePhysicalAddress;
    public final boolean isThroughputControlRequestRateTooLargeException;
    public final Double backendLatencyInMs;

    public StoreResult(StoreResponse storeResponse, CosmosException exception, String partitionKeyRangeId, long lsn, long quorumAckedLsn, double requestCharge, int currentReplicaSetSize, int currentWriteQuorum, boolean isValid, Uri storePhysicalAddress, long globalCommittedLSN, int numberOfReadRegions, long itemLSN, ISessionToken sessionToken, Double backendLatencyInMs) {
        this.storeResponse = storeResponse;
        this.exception = exception;
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.lsn = lsn;
        this.quorumAckedLSN = quorumAckedLsn;
        this.requestCharge = requestCharge;
        this.currentReplicaSetSize = currentReplicaSetSize;
        this.currentWriteQuorum = currentWriteQuorum;
        this.isValid = isValid;
        this.isGoneException = this.exception != null && this.exception.getStatusCode() == 410;
        this.isNotFoundException = this.exception != null && this.exception.getStatusCode() == 404;
        this.isInvalidPartitionException = this.exception != null && Exceptions.isNameCacheStale(this.exception);
        this.storePhysicalAddress = storePhysicalAddress;
        this.globalCommittedLSN = globalCommittedLSN;
        this.numberOfReadRegions = numberOfReadRegions;
        this.itemLSN = itemLSN;
        this.sessionToken = sessionToken;
        this.isThroughputControlRequestRateTooLargeException = this.exception != null && Exceptions.isThroughputControlRequestRateTooLargeException(this.exception);
        this.backendLatencyInMs = backendLatencyInMs;
    }

    public CosmosException getException() throws InternalServerErrorException {
        if (this.exception == null) {
            String message = "Exception should be available but found none";
            assert (false) : message;
            logger.error(message);
            throw new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support");
        }
        return this.exception;
    }

    public StoreResponse toResponse() {
        return this.toResponse(null);
    }

    public StoreResponse toResponse(RequestChargeTracker requestChargeTracker) {
        if (!this.isValid) {
            if (this.exception == null) {
                logger.error("Exception not set for invalid response");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support");
            }
            throw this.exception;
        }
        if (requestChargeTracker != null) {
            StoreResult.setRequestCharge(this.storeResponse, this.exception, requestChargeTracker.getTotalRequestCharge());
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.storeResponse;
    }

    private static void setRequestCharge(StoreResponse response, CosmosException cosmosException, double totalRequestCharge) {
        if (cosmosException != null) {
            cosmosException.getResponseHeaders().put("x-ms-request-charge", Double.toString(totalRequestCharge));
        } else if (response.getResponseHeaderNames() != null) {
            for (int i = 0; i < response.getResponseHeaderNames().length; ++i) {
                if (!Strings.areEqualIgnoreCase(response.getResponseHeaderNames()[i], "x-ms-request-charge")) continue;
                response.getResponseHeaderValues()[i] = Double.toString(totalRequestCharge);
                break;
            }
        }
    }

    public String toString() {
        int statusCode = 0;
        int subStatusCode = 0;
        if (this.storeResponse != null) {
            statusCode = this.storeResponse.getStatus();
            subStatusCode = this.storeResponse.getSubStatusCode();
        } else if (this.exception != null) {
            statusCode = this.exception.getStatusCode();
            subStatusCode = this.exception.getSubStatusCode();
        }
        return "storePhysicalAddress: " + this.storePhysicalAddress + ", lsn: " + this.lsn + ", globalCommittedLsn: " + this.globalCommittedLSN + ", partitionKeyRangeId: " + this.partitionKeyRangeId + ", isValid: " + this.isValid + ", statusCode: " + statusCode + ", subStatusCode: " + subStatusCode + ", isGone: " + this.isGoneException + ", isNotFound: " + this.isNotFoundException + ", isThroughputControlRequestRateTooLarge: " + this.isThroughputControlRequestRateTooLargeException + ", isInvalidPartition: " + this.isInvalidPartitionException + ", requestCharge: " + this.requestCharge + ", itemLSN: " + this.itemLSN + ", sessionToken: " + (this.sessionToken != null ? this.sessionToken.convertToString() : null) + ", backendLatencyInMs: " + this.backendLatencyInMs + ", exception: " + BridgeInternal.getInnerErrorMessage(this.exception);
    }

    public static class StoreResultSerializer
    extends StdSerializer<StoreResult> {
        private static final long serialVersionUID = 5315472126043077905L;

        public StoreResultSerializer() {
            super(StoreResult.class);
        }

        public void serialize(StoreResult storeResult, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int statusCode = 0;
            int subStatusCode = 0;
            if (storeResult.storeResponse != null) {
                statusCode = storeResult.storeResponse.getStatus();
                subStatusCode = storeResult.storeResponse.getSubStatusCode();
            } else if (storeResult.exception != null) {
                statusCode = storeResult.exception.getStatusCode();
                subStatusCode = storeResult.exception.getSubStatusCode();
            }
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("storePhysicalAddress", storeResult.storePhysicalAddress == null ? null : storeResult.storePhysicalAddress.getURIAsString());
            jsonGenerator.writeNumberField("lsn", storeResult.lsn);
            jsonGenerator.writeNumberField("globalCommittedLsn", storeResult.globalCommittedLSN);
            jsonGenerator.writeStringField("partitionKeyRangeId", storeResult.partitionKeyRangeId);
            jsonGenerator.writeBooleanField("isValid", storeResult.isValid);
            jsonGenerator.writeNumberField("statusCode", statusCode);
            jsonGenerator.writeNumberField("subStatusCode", subStatusCode);
            jsonGenerator.writeBooleanField("isGone", storeResult.isGoneException);
            jsonGenerator.writeBooleanField("isNotFound", storeResult.isNotFoundException);
            jsonGenerator.writeBooleanField("isInvalidPartition", storeResult.isInvalidPartitionException);
            jsonGenerator.writeBooleanField("isThroughputControlRequestRateTooLarge", storeResult.isThroughputControlRequestRateTooLargeException);
            jsonGenerator.writeNumberField("requestCharge", storeResult.requestCharge);
            jsonGenerator.writeNumberField("itemLSN", storeResult.itemLSN);
            jsonGenerator.writeStringField("sessionToken", storeResult.sessionToken != null ? storeResult.sessionToken.convertToString() : null);
            jsonGenerator.writeObjectField("backendLatencyInMs", (Object)storeResult.backendLatencyInMs);
            jsonGenerator.writeStringField("exception", BridgeInternal.getInnerErrorMessage(storeResult.exception));
            jsonGenerator.writeObjectField("transportRequestTimeline", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getRequestTimeline() : (storeResult.exception != null ? BridgeInternal.getRequestTimeline(storeResult.exception) : null)));
            jsonGenerator.writeObjectField("rntbdRequestLengthInBytes", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getRntbdRequestLength() : BridgeInternal.getRntbdRequestLength(storeResult.exception)));
            jsonGenerator.writeObjectField("rntbdResponseLengthInBytes", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getRntbdResponseLength() : BridgeInternal.getRntbdResponseLength(storeResult.exception)));
            jsonGenerator.writeObjectField("requestPayloadLengthInBytes", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getRequestPayloadLength() : BridgeInternal.getRequestBodyLength(storeResult.exception)));
            jsonGenerator.writeObjectField("responsePayloadLengthInBytes", storeResult.storeResponse != null ? Integer.valueOf(storeResult.storeResponse.getResponseBodyLength()) : null);
            jsonGenerator.writeObjectField("channelTaskQueueSize", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getRntbdChannelTaskQueueSize() : BridgeInternal.getChannelTaskQueueSize(storeResult.exception)));
            jsonGenerator.writeObjectField("pendingRequestsCount", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getPendingRequestQueueSize() : BridgeInternal.getRntbdPendingRequestQueueSize(storeResult.exception)));
            jsonGenerator.writeObjectField("serviceEndpointStatistics", (Object)(storeResult.storeResponse != null ? storeResult.storeResponse.getEndpointStsts() : (storeResult.exception != null ? BridgeInternal.getServiceEndpointStatistics(storeResult.exception) : null)));
            jsonGenerator.writeEndObject();
        }
    }
}

