/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class InternalServerErrorException
extends CosmosException {
    InternalServerErrorException() {
        this("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support");
    }

    public InternalServerErrorException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(500, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public InternalServerErrorException(String message) {
        this(message, null, (Map<String, String>)null, null);
    }

    InternalServerErrorException(String message, Exception innerException) {
        this(message, innerException, (HttpHeaders)null, (String)null);
    }

    InternalServerErrorException(Exception innerException) {
        this("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support", innerException, (HttpHeaders)null, (String)null);
    }

    public InternalServerErrorException(String message, HttpHeaders headers, URI requestUri) {
        super(message, null, HttpUtils.asMap(headers), 500, requestUri != null ? requestUri.toString() : null);
    }

    InternalServerErrorException(String message, HttpHeaders headers, String requestUriString) {
        super(message, null, HttpUtils.asMap(headers), 500, requestUriString);
    }

    InternalServerErrorException(String message, Exception innerException, HttpHeaders headers, URI requestUri) {
        super(message, innerException, HttpUtils.asMap(headers), 500, requestUri != null ? requestUri.toString() : null);
    }

    InternalServerErrorException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(message, innerException, HttpUtils.asMap(headers), 500, requestUriString);
    }

    public InternalServerErrorException(String message, Exception innerException, Map<String, String> headers, String requestUriString) {
        super(message, innerException, headers, 500, requestUriString);
    }
}

