/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.OperationKind;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;

public final class Conflict
extends Resource {
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();

    public Conflict() {
    }

    public Conflict(String jsonString) {
        super(jsonString);
    }

    public OperationKind getOperationKind() {
        return OperationKind.fromServiceSerializedFormat(super.getString("operationType"));
    }

    public String getResourceType() {
        return super.getString("resourceType");
    }

    public String getSourceResourceId() {
        return super.getString("resourceId");
    }

    public <T extends Resource> T getResource(Class<T> klass) {
        String resourceAsString = super.getString("content");
        if (!Strings.isNullOrEmpty(resourceAsString)) {
            try {
                return (T)((Resource)klass.getConstructor(String.class).newInstance(resourceAsString));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to instantiate class object.", e);
            }
        }
        return null;
    }

    public <T> T getItem(Class<T> klass) {
        String resourceAsString = super.getString("content");
        if (!Strings.isNullOrEmpty(resourceAsString)) {
            try {
                return (T)mapper.readValue(resourceAsString, klass);
            }
            catch (JsonProcessingException ex) {
                throw new IllegalStateException("Failed to deserialize  class object.", ex);
            }
        }
        return null;
    }
}

