/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.routing;

import com.azure.cosmos.internal.PartitionKeyRange;
import com.azure.cosmos.internal.routing.Range;
import com.azure.cosmos.internal.routing.RoutingMapProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class RoutingMapProviderHelper {
    private static final Range.MaxComparator<String> MAX_COMPARATOR = new Range.MaxComparator();

    private static String max(String left, String right) {
        return left.compareTo(right) < 0 ? right : left;
    }

    private static <T extends Comparable<T>> boolean IsSortedAndNonOverlapping(List<Range<T>> list) {
        for (int i = 1; i < list.size(); ++i) {
            Range<T> previousRange = list.get(i - 1);
            Range<T> currentRange = list.get(i);
            int compareResult = previousRange.getMax().compareTo(currentRange.getMin());
            if (compareResult > 0) {
                return false;
            }
            if (compareResult != 0 || !previousRange.isMaxInclusive() || !currentRange.isMinInclusive()) continue;
            return false;
        }
        return true;
    }

    public static Collection<PartitionKeyRange> getOverlappingRanges(RoutingMapProvider routingMapProvider, String collectionSelfLink, List<Range<String>> sortedRanges) {
        if (!RoutingMapProviderHelper.IsSortedAndNonOverlapping(sortedRanges)) {
            throw new IllegalArgumentException("sortedRanges");
        }
        ArrayList<PartitionKeyRange> targetRanges = new ArrayList<PartitionKeyRange>();
        int currentProvidedRange = 0;
        while (currentProvidedRange < sortedRanges.size()) {
            Range<String> queryRange;
            if (sortedRanges.get(currentProvidedRange).isEmpty()) {
                ++currentProvidedRange;
                continue;
            }
            if (!targetRanges.isEmpty()) {
                String left = RoutingMapProviderHelper.max(((PartitionKeyRange)targetRanges.get(targetRanges.size() - 1)).getMaxExclusive(), (String)sortedRanges.get(currentProvidedRange).getMin());
                boolean leftInclusive = left.compareTo((String)sortedRanges.get(currentProvidedRange).getMin()) == 0 ? sortedRanges.get(currentProvidedRange).isMinInclusive() : false;
                queryRange = new Range<String>(left, (String)sortedRanges.get(currentProvidedRange).getMax(), leftInclusive, sortedRanges.get(currentProvidedRange).isMaxInclusive());
            } else {
                queryRange = sortedRanges.get(currentProvidedRange);
            }
            targetRanges.addAll(routingMapProvider.getOverlappingRanges(collectionSelfLink, queryRange, false));
            Range<String> lastKnownTargetRange = ((PartitionKeyRange)targetRanges.get(targetRanges.size() - 1)).toRange();
            while (currentProvidedRange < sortedRanges.size() && MAX_COMPARATOR.compare(sortedRanges.get(currentProvidedRange), lastKnownTargetRange) <= 0) {
                ++currentProvidedRange;
            }
        }
        return targetRanges;
    }
}

