/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.query.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class TextTable {
    private static final char CellLeftTop = '\u250c';
    private static final char CellRightTop = '\u2510';
    private static final char CellLeftBottom = '\u2514';
    private static final char CellRightBottom = '\u2518';
    private static final char CellHorizontalJointTop = '\u252c';
    private static final char CellHorizontalJointBottom = '\u2534';
    private static final char CellVerticalJointLeft = '\u251c';
    private static final char CellTJoint = '\u253c';
    private static final char CellVerticalJointRight = '\u2524';
    private static final char CellHorizontalLine = '-';
    private static final char CellVerticalLine = '\u2502';
    private List<Column> columns;
    private String header;
    private String topLine;
    private String middleLine;
    private String bottomLine;
    private String rowFormatString;

    public TextTable(List<Column> columns) {
        this.columns = new ArrayList<Column>(columns);
        String headerFormatString = TextTable.buildLineFormatString(columns);
        this.header = String.format(headerFormatString, columns.stream().map(textTableColumn -> textTableColumn.columnName).toArray());
        this.topLine = TextTable.buildLine('\u250c', '\u2510', '\u252c', columns);
        this.middleLine = TextTable.buildLine('\u251c', '\u2524', '\u253c', columns);
        this.bottomLine = TextTable.buildLine('\u2514', '\u2518', '\u2534', columns);
        this.rowFormatString = TextTable.buildLineFormatString(columns);
    }

    public String getRow(List<Object> cells) {
        if (cells.size() != this.columns.size()) {
            throw new IllegalArgumentException("Cells in a row needs to have exactly 1 element per column");
        }
        return String.format(this.rowFormatString, cells.toArray());
    }

    private static String buildLine(char firstChar, char lastChar, char seperator, List<Column> columns) {
        StringBuilder lineStringBuilder = new StringBuilder();
        lineStringBuilder.append(firstChar);
        for (Column column : columns.subList(0, columns.size() - 1)) {
            lineStringBuilder.append(StringUtils.repeat((char)'-', (int)column.columnWidth));
            lineStringBuilder.append(seperator);
        }
        lineStringBuilder.append(StringUtils.repeat((char)'-', (int)columns.get((int)(columns.size() - 1)).columnWidth));
        lineStringBuilder.append(lastChar);
        return lineStringBuilder.toString();
    }

    private static String buildLineFormatString(List<Column> columns) {
        StringBuilder lineFormatStringBuilder = new StringBuilder();
        lineFormatStringBuilder.append('\u2502');
        for (Column column : columns) {
            lineFormatStringBuilder.append("%" + column.columnWidth + "s");
            lineFormatStringBuilder.append('\u2502');
        }
        return lineFormatStringBuilder.toString();
    }

    public String getHeader() {
        return this.header;
    }

    public String getTopLine() {
        return this.topLine;
    }

    public String getMiddleLine() {
        return this.middleLine;
    }

    public String getBottomLine() {
        return this.bottomLine;
    }

    static class Column {
        String columnName;
        int columnWidth;

        public Column(String columnName, int columnWidth) {
            this.columnName = columnName;
            this.columnWidth = columnWidth;
        }
    }
}

