/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.JsonSerializable;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.query.CompositeContinuationToken;
import com.azure.cosmos.internal.query.QueryItem;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderByContinuationToken
extends JsonSerializable {
    private static final String CompositeContinuationTokenPropertyName = "compositeToken";
    private static final String OrderByItemsPropetryName = "orderByItems";
    private static final String RidPropertyName = "rid";
    private static final String InclusivePropertyName = "inclusive";
    private static final Logger logger = LoggerFactory.getLogger(OrderByContinuationToken.class);

    public OrderByContinuationToken(CompositeContinuationToken compositeContinuationToken, QueryItem[] orderByItems, String rid, boolean inclusive) {
        if (compositeContinuationToken == null) {
            throw new IllegalArgumentException("CompositeContinuationToken must not be null.");
        }
        if (orderByItems == null) {
            throw new IllegalArgumentException("orderByItems must not be null.");
        }
        if (orderByItems.length == 0) {
            throw new IllegalArgumentException("orderByItems must not be empty.");
        }
        if (rid == null) {
            throw new IllegalArgumentException("rid must not be null.");
        }
        this.setCompositeContinuationToken(compositeContinuationToken);
        this.setOrderByItems(orderByItems);
        this.setRid(rid);
        this.setInclusive(inclusive);
    }

    private OrderByContinuationToken(String serializedOrderByContinuationToken) {
        super(serializedOrderByContinuationToken);
    }

    public static boolean tryParse(String serializedOrderByContinuationToken, Utils.ValueHolder<OrderByContinuationToken> outOrderByContinuationToken) {
        boolean parsed;
        try {
            OrderByContinuationToken orderByContinuationToken = new OrderByContinuationToken(serializedOrderByContinuationToken);
            CompositeContinuationToken compositeContinuationToken = orderByContinuationToken.getCompositeContinuationToken();
            if (compositeContinuationToken == null) {
                throw new IllegalArgumentException("compositeContinuationToken must not be null.");
            }
            orderByContinuationToken.getOrderByItems();
            orderByContinuationToken.getRid();
            orderByContinuationToken.getInclusive();
            outOrderByContinuationToken.v = orderByContinuationToken;
            parsed = true;
        }
        catch (Exception ex) {
            logger.debug("Received exception {} when trying to parse: {}", (Object)ex.getMessage(), (Object)serializedOrderByContinuationToken);
            parsed = false;
            outOrderByContinuationToken.v = null;
        }
        return parsed;
    }

    public CompositeContinuationToken getCompositeContinuationToken() {
        Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken = new Utils.ValueHolder<CompositeContinuationToken>();
        boolean succeeded = CompositeContinuationToken.tryParse(super.getString(CompositeContinuationTokenPropertyName), outCompositeContinuationToken);
        if (!succeeded) {
            throw new IllegalArgumentException("Continuation Token was not able to be parsed");
        }
        return (CompositeContinuationToken)outCompositeContinuationToken.v;
    }

    public QueryItem[] getOrderByItems() {
        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
        ArrayNode arrayNode = (ArrayNode)super.get(OrderByItemsPropetryName);
        for (JsonNode jsonNode : arrayNode) {
            QueryItem queryItem = new QueryItem(jsonNode.toString());
            queryItems.add(queryItem);
        }
        QueryItem[] queryItemsArray = new QueryItem[queryItems.size()];
        return queryItems.toArray(queryItemsArray);
    }

    public String getRid() {
        return super.getString(RidPropertyName);
    }

    public boolean getInclusive() {
        return super.getBoolean(InclusivePropertyName);
    }

    private void setCompositeContinuationToken(CompositeContinuationToken compositeContinuationToken) {
        BridgeInternal.setProperty(this, CompositeContinuationTokenPropertyName, compositeContinuationToken.toJson());
    }

    private void setOrderByItems(QueryItem[] orderByItems) {
        BridgeInternal.setProperty(this, OrderByItemsPropetryName, orderByItems);
    }

    private void setRid(String rid) {
        BridgeInternal.setProperty(this, RidPropertyName, rid);
    }

    private void setInclusive(boolean inclusive) {
        BridgeInternal.setProperty(this, InclusivePropertyName, inclusive);
    }
}

