/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.http;

import com.azure.cosmos.internal.http.HttpHeader;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class HttpHeaders
implements Iterable<HttpHeader>,
JsonSerializable {
    private Map<String, HttpHeader> headers;

    public HttpHeaders() {
        this.headers = new HashMap<String, HttpHeader>();
    }

    public HttpHeaders(int size) {
        this.headers = new HashMap<String, HttpHeader>(size);
    }

    public HttpHeaders(Map<String, String> headers) {
        this.headers = new HashMap<String, HttpHeader>(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            this.set(header.getKey(), header.getValue());
        }
    }

    public int size() {
        return this.headers.size();
    }

    public HttpHeaders set(String name, String value) {
        String headerKey = name.toLowerCase(Locale.ROOT);
        if (value == null) {
            this.headers.remove(headerKey);
        } else {
            this.headers.put(headerKey, new HttpHeader(name, value));
        }
        return this;
    }

    public String value(String name) {
        HttpHeader header = this.getHeader(name);
        return header == null ? null : header.value();
    }

    public String[] values(String name) {
        HttpHeader header = this.getHeader(name);
        return header == null ? null : header.values();
    }

    private HttpHeader getHeader(String headerName) {
        String headerKey = headerName.toLowerCase(Locale.ROOT);
        return this.headers.get(headerKey);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.headers.size());
        for (HttpHeader header : this.headers.values()) {
            result.put(header.name(), header.value());
        }
        return result;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(this.toMap());
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(jsonGenerator, serializerProvider);
    }
}

