/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.http;

import com.azure.cosmos.internal.http.HttpClientConfig;
import com.azure.cosmos.internal.http.HttpRequest;
import com.azure.cosmos.internal.http.HttpResponse;
import com.azure.cosmos.internal.http.ReactorNettyClient;
import java.time.Duration;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;

public interface HttpClient {
    public Mono<HttpResponse> send(HttpRequest var1);

    public static HttpClient createFixed(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        Integer maxIdleConnectionTimeoutInMillis = httpClientConfig.getConfigs().getMaxIdleConnectionTimeoutInMillis();
        if (httpClientConfig.getMaxIdleConnectionTimeoutInMillis() != null) {
            maxIdleConnectionTimeoutInMillis = httpClientConfig.getMaxIdleConnectionTimeoutInMillis();
        }
        Integer maxPoolSize = httpClientConfig.getConfigs().getReactorNettyMaxConnectionPoolSize();
        if (httpClientConfig.getMaxPoolSize() != null) {
            maxPoolSize = httpClientConfig.getMaxPoolSize();
        }
        int connectionAcquireTimeoutInMillis = httpClientConfig.getConfigs().getConnectionAcquireTimeoutInMillis();
        ConnectionProvider fixedConnectionProvider = ConnectionProvider.fixed((String)httpClientConfig.getConfigs().getReactorNettyConnectionPoolName(), (int)maxPoolSize, (long)connectionAcquireTimeoutInMillis, (Duration)Duration.ofMillis(maxIdleConnectionTimeoutInMillis.intValue()));
        return ReactorNettyClient.createWithConnectionProvider(fixedConnectionProvider, httpClientConfig);
    }

    public static HttpClient create(HttpClientConfig httpClientConfig) {
        if (httpClientConfig.getConfigs() == null) {
            throw new IllegalArgumentException("HttpClientConfig is null");
        }
        return ReactorNettyClient.create(httpClientConfig);
    }

    public void shutdown();
}

