/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.http;

import com.azure.cosmos.internal.http.HttpHeaders;
import com.azure.cosmos.internal.http.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final Mono<byte[]> cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.bodyAsByteArray().cache();
        this.withRequest(innerHttpResponse.request());
    }

    @Override
    public int statusCode() {
        return this.innerHttpResponse.statusCode();
    }

    @Override
    public String headerValue(String name) {
        return this.innerHttpResponse.headerValue(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.innerHttpResponse.headers();
    }

    @Override
    public Mono<byte[]> bodyAsByteArray() {
        return this.cachedBody;
    }

    @Override
    public Flux<ByteBuf> body() {
        return this.bodyAsByteArray().flatMapMany(bytes -> Flux.just((Object)Unpooled.wrappedBuffer((byte[])bytes)));
    }

    @Override
    public Mono<String> bodyAsString() {
        return this.bodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    @Override
    public Mono<String> bodyAsString(Charset charset) {
        return this.bodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, charset));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

