/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity.rntbd;

import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdUUID;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Utf8;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

enum RntbdTokenType {
    Byte(0, RntbdByte.codec),
    UShort(1, RntbdUnsignedShort.codec),
    ULong(2, RntbdUnsignedInteger.codec),
    Long(3, RntbdInteger.codec),
    ULongLong(4, RntbdLong.codec),
    LongLong(5, RntbdLong.codec),
    Guid(6, RntbdGuid.codec),
    SmallString(7, RntbdShortString.codec),
    String(8, RntbdString.codec),
    ULongString(9, RntbdLongString.codec),
    SmallBytes(10, RntbdShortBytes.codec),
    Bytes(11, RntbdBytes.codec),
    ULongBytes(12, RntbdLongBytes.codec),
    Float(13, RntbdFloat.codec),
    Double(14, RntbdDouble.codec),
    Invalid(-1, RntbdNone.codec);

    private Codec codec;
    private byte id;

    private RntbdTokenType(byte id, Codec codec) {
        this.codec = codec;
        this.id = id;
    }

    public Codec codec() {
        return this.codec;
    }

    public static RntbdTokenType fromId(byte value) {
        for (RntbdTokenType tokenType : RntbdTokenType.values()) {
            if (value != tokenType.id) continue;
            return tokenType;
        }
        return Invalid;
    }

    public byte id() {
        return this.id;
    }

    private static class RntbdUnsignedShort
    implements Codec {
        public static final Codec codec = new RntbdUnsignedShort();

        private RntbdUnsignedShort() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 2;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return ((Number)value).intValue() & 0xFFFF;
        }

        @Override
        public final Object defaultValue() {
            return 0;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number;
        }

        @Override
        public final Object read(ByteBuf in) {
            return in.readUnsignedShortLE();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(2);
        }

        @Override
        public Class<?> valueType() {
            return Integer.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeShortLE((int)((Number)value).shortValue());
        }
    }

    private static class RntbdUnsignedInteger
    implements Codec {
        public static final Codec codec = new RntbdUnsignedInteger();

        private RntbdUnsignedInteger() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 4;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return ((Number)value).longValue() & 0xFFFFFFFFL;
        }

        @Override
        public final Object defaultValue() {
            return 0L;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number;
        }

        @Override
        public final Object read(ByteBuf in) {
            return in.readUnsignedIntLE();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(4);
        }

        @Override
        public Class<?> valueType() {
            return Long.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeIntLE(((Number)value).intValue());
        }
    }

    private static class RntbdString
    implements Codec {
        public static final Codec codec = new RntbdString();

        private RntbdString() {
        }

        final int computeLength(Object value, int maxLength) {
            int length;
            Object string;
            assert (this.isValid(value));
            if (value instanceof String) {
                string = (String)value;
                length = Utf8.encodedLength((CharSequence)string);
            } else {
                string = (byte[])value;
                if (!Utf8.isWellFormed((byte[])string)) {
                    String reason = Strings.lenientFormat((String)"UTF-8 byte string is ill-formed: %s", (Object[])new Object[]{ByteBufUtil.hexDump((byte[])string)});
                    throw new DecoderException(reason);
                }
                length = ((Object)string).length;
            }
            if (length > maxLength) {
                String reason = Strings.lenientFormat((String)"UTF-8 byte string exceeds %s bytes: %s bytes", (Object[])new Object[]{maxLength, length});
                throw new DecoderException(reason);
            }
            return length;
        }

        @Override
        public int computeLength(Object value) {
            return 2 + this.computeLength(value, 65535);
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return value instanceof String ? value : new String((byte[])value, StandardCharsets.UTF_8);
        }

        @Override
        public final Object defaultValue() {
            return "";
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof String || value instanceof byte[];
        }

        @Override
        public Object read(ByteBuf in) {
            int length = in.readUnsignedShortLE();
            Codec.checkReadableBytes(in, length, 65535L);
            return in.readCharSequence(length, StandardCharsets.UTF_8).toString();
        }

        @Override
        public ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(2 + in.getUnsignedShortLE(in.readerIndex()));
        }

        @Override
        public Class<?> valueType() {
            return String.class;
        }

        @Override
        public void write(Object value, ByteBuf out) {
            int length = this.computeLength(value, 65535);
            out.writeShortLE(length);
            RntbdString.writeValue(out, value, length);
        }

        static void writeValue(ByteBuf out, Object value, int length) {
            int start = out.writerIndex();
            if (value instanceof String) {
                out.writeCharSequence((CharSequence)((String)value), StandardCharsets.UTF_8);
            } else {
                out.writeBytes((byte[])value);
            }
            assert (out.writerIndex() - start == length);
        }
    }

    private static class RntbdShortString
    extends RntbdString {
        public static final Codec codec = new RntbdShortString();

        private RntbdShortString() {
        }

        @Override
        public final int computeLength(Object value) {
            return 1 + this.computeLength(value, 255);
        }

        @Override
        public final Object read(ByteBuf in) {
            short length = in.readUnsignedByte();
            Codec.checkReadableBytes(in, length, 255L);
            return in.readCharSequence((int)length, StandardCharsets.UTF_8).toString();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(1 + in.getUnsignedByte(in.readerIndex()));
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            int length = this.computeLength(value, 255);
            out.writeByte(length);
            RntbdShortString.writeValue(out, value, length);
        }
    }

    private static class RntbdShortBytes
    extends RntbdBytes {
        public static final Codec codec = new RntbdShortBytes();

        private RntbdShortBytes() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 1 + ((byte[])value).length;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof byte[] && ((byte[])value).length <= 255;
        }

        @Override
        public final Object read(ByteBuf in) {
            short length = in.readUnsignedByte();
            Codec.checkReadableBytes(in, length, 255L);
            byte[] bytes = new byte[length];
            in.readBytes(bytes);
            return bytes;
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(1 + in.getUnsignedByte(in.readerIndex()));
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            byte[] bytes = (byte[])value;
            int length = bytes.length;
            if (length > 255) {
                throw new IllegalStateException();
            }
            out.writeByte((int)((byte)length));
            out.writeBytes(bytes);
        }
    }

    private static class RntbdNone
    implements Codec {
        public static final Codec codec = new RntbdNone();

        private RntbdNone() {
        }

        @Override
        public final int computeLength(Object value) {
            return 0;
        }

        @Override
        public final Object convert(Object value) {
            return null;
        }

        @Override
        public final Object defaultValue() {
            return null;
        }

        @Override
        public final boolean isValid(Object value) {
            return true;
        }

        @Override
        public final Object read(ByteBuf in) {
            return null;
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return null;
        }

        @Override
        public Class<?> valueType() {
            return null;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
        }
    }

    private static class RntbdLongString
    extends RntbdString {
        public static final Codec codec = new RntbdLongString();

        private RntbdLongString() {
        }

        @Override
        public final int computeLength(Object value) {
            return 4 + this.computeLength(value, Integer.MAX_VALUE);
        }

        @Override
        public final Object read(ByteBuf in) {
            long length = in.readUnsignedIntLE();
            Codec.checkReadableBytes(in, length, Integer.MAX_VALUE);
            return in.readCharSequence((int)length, StandardCharsets.UTF_8).toString();
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            int length = this.computeLength(value, Integer.MAX_VALUE);
            out.writeIntLE(length);
            RntbdLongString.writeValue(out, value, length);
        }
    }

    private static class RntbdLongBytes
    extends RntbdBytes {
        public static final Codec codec = new RntbdLongBytes();

        private RntbdLongBytes() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 4 + ((byte[])value).length;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof byte[];
        }

        @Override
        public final Object read(ByteBuf in) {
            long length = in.readUnsignedIntLE();
            Codec.checkReadableBytes(in, length, Integer.MAX_VALUE);
            return in.readBytes((int)length);
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            long length = in.getUnsignedIntLE(in.readerIndex());
            Preconditions.checkState((length <= Integer.MAX_VALUE ? 1 : 0) != 0);
            return in.readSlice(4 + (int)length);
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            byte[] bytes = (byte[])value;
            out.writeIntLE(bytes.length);
            out.writeBytes(bytes);
        }
    }

    private static class RntbdLong
    implements Codec {
        public static final Codec codec = new RntbdLong();

        private RntbdLong() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 8;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return ((Number)value).longValue();
        }

        @Override
        public final Object defaultValue() {
            return 0L;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number;
        }

        @Override
        public final Object read(ByteBuf in) {
            return in.readLongLE();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(8);
        }

        @Override
        public Class<?> valueType() {
            return Long.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeLongLE(((Number)value).longValue());
        }
    }

    private static class RntbdInteger
    implements Codec {
        public static final Codec codec = new RntbdInteger();

        private RntbdInteger() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 4;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return ((Number)value).intValue();
        }

        @Override
        public final Object defaultValue() {
            return 0;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number;
        }

        @Override
        public final Object read(ByteBuf in) {
            return in.readIntLE();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(4);
        }

        @Override
        public Class<?> valueType() {
            return Integer.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeIntLE(((Number)value).intValue());
        }
    }

    private static class RntbdGuid
    implements Codec {
        public static final Codec codec = new RntbdGuid();

        private RntbdGuid() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 16;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return value;
        }

        @Override
        public final Object defaultValue() {
            return RntbdUUID.EMPTY;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof UUID;
        }

        @Override
        public final Object read(ByteBuf in) {
            return RntbdUUID.decode(in);
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(16);
        }

        @Override
        public Class<?> valueType() {
            return UUID.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            RntbdUUID.encode((UUID)value, out);
        }
    }

    private static class RntbdFloat
    implements Codec {
        public static final Codec codec = new RntbdFloat();

        private RntbdFloat() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 4;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return java.lang.Float.valueOf(((Number)value).floatValue());
        }

        @Override
        public final Object defaultValue() {
            return java.lang.Float.valueOf(0.0f);
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number;
        }

        @Override
        public final Object read(ByteBuf in) {
            return java.lang.Float.valueOf(in.readFloatLE());
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(4);
        }

        @Override
        public Class<?> valueType() {
            return Float.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeFloatLE(((Number)value).floatValue());
        }
    }

    private static class RntbdDouble
    implements Codec {
        public static final Codec codec = new RntbdDouble();

        private RntbdDouble() {
        }

        @Override
        public final int computeLength(Object value) {
            assert (this.isValid(value));
            return 8;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return ((Number)value).doubleValue();
        }

        @Override
        public final Object defaultValue() {
            return 0.0;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number;
        }

        @Override
        public final Object read(ByteBuf in) {
            return in.readDoubleLE();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(8);
        }

        @Override
        public Class<?> valueType() {
            return Double.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeDoubleLE(((Number)value).doubleValue());
        }
    }

    private static class RntbdBytes
    implements Codec {
        public static final Codec codec = new RntbdBytes();
        private static final byte[] defaultValue = new byte[0];

        private RntbdBytes() {
        }

        @Override
        public int computeLength(Object value) {
            assert (this.isValid(value));
            return 2 + ((byte[])value).length;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            return value;
        }

        @Override
        public final Object defaultValue() {
            return defaultValue;
        }

        @Override
        public boolean isValid(Object value) {
            return value instanceof byte[] && ((byte[])value).length < 65535;
        }

        @Override
        public Object read(ByteBuf in) {
            int length = in.readUnsignedShortLE();
            Codec.checkReadableBytes(in, length, 65535L);
            return in.readBytes(length);
        }

        @Override
        public ByteBuf readSlice(ByteBuf in) {
            int length = in.getUnsignedShortLE(in.readerIndex());
            return in.readSlice(2 + length);
        }

        @Override
        public Class<?> valueType() {
            return Byte[].class;
        }

        @Override
        public void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            byte[] bytes = (byte[])value;
            int length = bytes.length;
            if (length > 65535) {
                throw new IllegalStateException();
            }
            out.writeShortLE((int)((short)length));
            out.writeBytes(bytes);
        }
    }

    private static class RntbdByte
    implements Codec {
        public static final Codec codec = new RntbdByte();

        private RntbdByte() {
        }

        @Override
        public final int computeLength(Object value) {
            return 1;
        }

        @Override
        public final Object convert(Object value) {
            assert (this.isValid(value));
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return (Boolean)value != false ? (byte)1 : 0;
        }

        @Override
        public final Object defaultValue() {
            return (byte)0;
        }

        @Override
        public final boolean isValid(Object value) {
            return value instanceof Number || value instanceof Boolean;
        }

        @Override
        public final Object read(ByteBuf in) {
            return in.readByte();
        }

        @Override
        public final ByteBuf readSlice(ByteBuf in) {
            return in.readSlice(1);
        }

        @Override
        public final Class<?> valueType() {
            return Byte.class;
        }

        @Override
        public final void write(Object value, ByteBuf out) {
            assert (this.isValid(value));
            out.writeByte((int)(value instanceof Byte ? (Byte)value : ((Boolean)value != false ? (byte)1 : 0)));
        }
    }

    public static interface Codec {
        public int computeLength(Object var1);

        public Object convert(Object var1);

        public Object defaultValue();

        public boolean isValid(Object var1);

        public Object read(ByteBuf var1);

        public ByteBuf readSlice(ByteBuf var1);

        public Class<?> valueType();

        public void write(Object var1, ByteBuf var2);

        public static void checkReadableBytes(ByteBuf in, long length, long maxLength) {
            if (length != (long)in.readableBytes() || length > maxLength) {
                String message = Strings.lenientFormat((String)"maxLength: %s, length: %s, readableBytes: %s", (Object[])new Object[]{maxLength, length, in.readableBytes()});
                throw new CorruptedFrameException(message);
            }
        }
    }
}

