/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity;

import com.azure.cosmos.BadRequestException;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.RxDocumentServiceResponse;
import com.azure.cosmos.internal.RxStoreModel;
import com.azure.cosmos.internal.Strings;
import com.azure.cosmos.internal.directconnectivity.ReplicatedResourceClient;
import com.azure.cosmos.internal.directconnectivity.StoreClient;
import org.apache.commons.lang3.EnumUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerStoreModel
implements RxStoreModel {
    private final StoreClient storeClient;

    public ServerStoreModel(StoreClient storeClient) {
        this.storeClient = storeClient;
    }

    @Override
    public Flux<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        String requestConsistencyLevelHeaderValue = request.getHeaders().get("x-ms-consistency-level");
        request.requestContext.originalRequestConsistencyLevel = null;
        if (!Strings.isNullOrEmpty(requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = (ConsistencyLevel)EnumUtils.getEnum(ConsistencyLevel.class, (String)Strings.fromCamelCaseToUpperCase(requestConsistencyLevelHeaderValue));
            if (requestConsistencyLevel == null) {
                return Flux.error((Throwable)new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level")));
            }
            request.requestContext.originalRequestConsistencyLevel = requestConsistencyLevel;
        }
        if (ReplicatedResourceClient.isMasterResource(request.getResourceType())) {
            request.getHeaders().put("x-ms-consistency-level", ConsistencyLevel.STRONG.toString());
        }
        Mono<RxDocumentServiceResponse> response = this.storeClient.processMessageAsync(request);
        return response.flux();
    }
}

