/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity;

import com.azure.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.cosmos.internal.directconnectivity.StoreResponse;
import com.azure.cosmos.internal.http.HttpHeaders;
import com.azure.cosmos.internal.http.HttpRequest;
import com.azure.cosmos.internal.http.HttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import reactor.core.publisher.Mono;

class ResponseUtils {
    ResponseUtils() {
    }

    static Mono<StoreResponse> toStoreResponse(HttpResponse httpClientResponse, HttpRequest httpRequest) {
        HttpHeaders httpResponseHeaders = httpClientResponse.headers();
        Mono<String> contentObservable = httpRequest.httpMethod() == HttpMethod.DELETE ? Mono.just((Object)"") : httpClientResponse.bodyAsString();
        return contentObservable.flatMap(content -> {
            try {
                StoreResponse rsp = new StoreResponse(httpClientResponse.statusCode(), HttpUtils.unescape(httpResponseHeaders.toMap().entrySet()), (String)content);
                return Mono.just((Object)rsp);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }
}

