/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity;

import com.azure.cosmos.internal.directconnectivity.Protocol;
import java.util.Objects;

public class AddressInformation {
    private Protocol protocol;
    private boolean isPublic;
    private boolean isPrimary;
    private String physicalUri;

    public AddressInformation(boolean isPublic, boolean isPrimary, String physicalUri, Protocol protocol) {
        Objects.requireNonNull(protocol);
        this.protocol = protocol;
        this.isPublic = isPublic;
        this.isPrimary = isPrimary;
        this.physicalUri = physicalUri;
    }

    public AddressInformation(boolean isPublic, boolean isPrimary, String physicalUri, String protocolScheme) {
        this(isPublic, isPrimary, physicalUri, AddressInformation.scheme2protocol(protocolScheme));
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public String getPhysicalUri() {
        return this.physicalUri;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getProtocolName() {
        return this.protocol.toString();
    }

    public String getProtocolScheme() {
        return this.protocol.scheme();
    }

    public String toString() {
        return "AddressInformation{protocol='" + (Object)((Object)this.protocol) + '\'' + ", isPublic=" + this.isPublic + ", isPrimary=" + this.isPrimary + ", physicalUri='" + this.physicalUri + '\'' + '}';
    }

    private static Protocol scheme2protocol(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        switch (scheme.toLowerCase()) {
            case "https": {
                return Protocol.HTTPS;
            }
            case "rntbd": {
                return Protocol.TCP;
            }
        }
        throw new IllegalArgumentException(String.format("scheme: %s", scheme));
    }
}

