/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.changefeed.implementation;

import com.azure.cosmos.internal.changefeed.Lease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerTask
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(WorkerTask.class);
    private boolean done = false;
    private Runnable job;
    private Lease lease;

    WorkerTask(Lease lease, Runnable job) {
        this.lease = lease;
        this.job = job;
    }

    @Override
    public void run() {
        try {
            this.job.run();
            this.logger.info("Partition controller worker task {} has finished running.", (Object)this.lease.getLeaseToken());
        }
        finally {
            this.logger.info("Partition controller worker task {} has exited.", (Object)this.lease.getLeaseToken());
            this.job = null;
            this.done = true;
        }
    }

    public Lease lease() {
        return this.lease;
    }

    public boolean isRunning() {
        return !this.done;
    }
}

