/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.changefeed.implementation;

import com.azure.cosmos.internal.changefeed.Bootstrapper;
import com.azure.cosmos.internal.changefeed.PartitionController;
import com.azure.cosmos.internal.changefeed.PartitionLoadBalancer;
import com.azure.cosmos.internal.changefeed.PartitionManager;
import reactor.core.publisher.Mono;

class PartitionManagerImpl
implements PartitionManager {
    private final Bootstrapper bootstrapper;
    private final PartitionController partitionController;
    private final PartitionLoadBalancer partitionLoadBalancer;

    public PartitionManagerImpl(Bootstrapper bootstrapper, PartitionController partitionController, PartitionLoadBalancer partitionLoadBalancer) {
        this.bootstrapper = bootstrapper;
        this.partitionController = partitionController;
        this.partitionLoadBalancer = partitionLoadBalancer;
    }

    @Override
    public Mono<Void> start() {
        return this.bootstrapper.initialize().then(this.partitionController.initialize()).then(this.partitionLoadBalancer.start());
    }

    @Override
    public Mono<Void> stop() {
        return this.partitionLoadBalancer.stop();
    }

    @Override
    public boolean isRunning() {
        return this.partitionLoadBalancer.isRunning();
    }
}

