/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.changefeed.implementation;

import com.azure.cosmos.internal.changefeed.Bootstrapper;
import com.azure.cosmos.internal.changefeed.LeaseStore;
import com.azure.cosmos.internal.changefeed.PartitionSynchronizer;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class BootstrapperImpl
implements Bootstrapper {
    private final Logger logger = LoggerFactory.getLogger(BootstrapperImpl.class);
    private final PartitionSynchronizer synchronizer;
    private final LeaseStore leaseStore;
    private final Duration lockTime;
    private final Duration sleepTime;
    private volatile boolean isInitialized;
    private volatile boolean isLockAcquired;

    public BootstrapperImpl(PartitionSynchronizer synchronizer, LeaseStore leaseStore, Duration lockTime, Duration sleepTime) {
        if (synchronizer == null) {
            throw new IllegalArgumentException("synchronizer");
        }
        if (leaseStore == null) {
            throw new IllegalArgumentException("leaseStore");
        }
        if (lockTime == null || lockTime.isNegative() || lockTime.isZero()) {
            throw new IllegalArgumentException("lockTime should be non-null and positive");
        }
        if (sleepTime == null || sleepTime.isNegative() || sleepTime.isZero()) {
            throw new IllegalArgumentException("sleepTime should be non-null and positive");
        }
        this.synchronizer = synchronizer;
        this.leaseStore = leaseStore;
        this.lockTime = lockTime;
        this.sleepTime = sleepTime;
        this.isInitialized = false;
    }

    @Override
    public Mono<Void> initialize() {
        this.isInitialized = false;
        return Mono.just((Object)this).flatMap(value -> this.leaseStore.isInitialized()).flatMap(initialized -> {
            this.isInitialized = initialized;
            if (initialized.booleanValue()) {
                return Mono.empty();
            }
            return this.leaseStore.acquireInitializationLock(this.lockTime).flatMap(lockAcquired -> {
                this.isLockAcquired = lockAcquired;
                if (!this.isLockAcquired) {
                    this.logger.info("Another instance is initializing the store");
                    return Mono.just((Object)this.isLockAcquired).delayElement(this.sleepTime);
                }
                return this.synchronizer.createMissingLeases().then(this.leaseStore.markInitialized());
            }).onErrorResume(throwable -> {
                this.logger.warn("Unexpected exception caught", throwable);
                return Mono.just((Object)this.isLockAcquired);
            }).flatMap(lockAcquired -> {
                if (this.isLockAcquired) {
                    return this.leaseStore.releaseInitializationLock();
                }
                return Mono.just((Object)lockAcquired);
            });
        }).repeat(() -> !this.isInitialized).then();
    }
}

