/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.changefeed;

import com.azure.cosmos.internal.changefeed.CancellationToken;
import java.io.Closeable;
import java.io.IOException;

public class CancellationTokenSource
implements Closeable {
    private volatile boolean tokenSourceClosed = false;
    private volatile boolean cancellationRequested = false;

    public synchronized boolean isCancellationRequested() {
        if (this.tokenSourceClosed) {
            throw new IllegalStateException("Object already closed");
        }
        return this.cancellationRequested;
    }

    public CancellationToken getToken() {
        return new CancellationToken(this);
    }

    public synchronized void cancel() {
        this.cancellationRequested = true;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.tokenSourceClosed) {
            return;
        }
    }
}

