/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.caches;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.internal.AuthorizationTokenType;
import com.azure.cosmos.internal.ClearingSessionContainerClientRetryPolicy;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.IAuthorizationTokenProvider;
import com.azure.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.cosmos.internal.IRetryPolicyFactory;
import com.azure.cosmos.internal.ISessionContainer;
import com.azure.cosmos.internal.ObservableHelper;
import com.azure.cosmos.internal.OperationType;
import com.azure.cosmos.internal.PathsHelper;
import com.azure.cosmos.internal.ResourceType;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.RxDocumentServiceResponse;
import com.azure.cosmos.internal.RxStoreModel;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.caches.RxCollectionCache;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxClientCollectionCache
extends RxCollectionCache {
    private RxStoreModel storeModel;
    private final IAuthorizationTokenProvider tokenProvider;
    private final IRetryPolicyFactory retryPolicy;
    private final ISessionContainer sessionContainer;

    public RxClientCollectionCache(ISessionContainer sessionContainer, RxStoreModel storeModel, IAuthorizationTokenProvider tokenProvider, IRetryPolicyFactory retryPolicy) {
        this.storeModel = storeModel;
        this.tokenProvider = tokenProvider;
        this.retryPolicy = retryPolicy;
        this.sessionContainer = sessionContainer;
    }

    @Override
    protected Mono<DocumentCollection> getByRidAsync(String collectionRid, Map<String, Object> properties) {
        ClearingSessionContainerClientRetryPolicy retryPolicyInstance = new ClearingSessionContainerClientRetryPolicy(this.sessionContainer, this.retryPolicy.getRequestPolicy());
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(PathsHelper.generatePath(ResourceType.DocumentCollection, collectionRid, false), retryPolicyInstance, properties), retryPolicyInstance);
    }

    @Override
    protected Mono<DocumentCollection> getByNameAsync(String resourceAddress, Map<String, Object> properties) {
        ClearingSessionContainerClientRetryPolicy retryPolicyInstance = new ClearingSessionContainerClientRetryPolicy(this.sessionContainer, this.retryPolicy.getRequestPolicy());
        return ObservableHelper.inlineIfPossible(() -> this.readCollectionAsync(resourceAddress, retryPolicyInstance, properties), retryPolicyInstance);
    }

    private Mono<DocumentCollection> readCollectionAsync(String collectionLink, IDocumentClientRetryPolicy retryPolicyInstance, Map<String, Object> properties) {
        String path = Utils.joinPath(collectionLink, null);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, path, new HashMap<String, String>());
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        String resourceName = request.getResourceAddress();
        String authorizationToken = this.tokenProvider.getUserAuthorizationToken(resourceName, request.getResourceType(), "GET", request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, properties);
        try {
            authorizationToken = URLEncoder.encode(authorizationToken, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return Mono.error((Throwable)new IllegalStateException("Failed to encode authtoken.", e));
        }
        request.getHeaders().put("authorization", authorizationToken);
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        Flux<RxDocumentServiceResponse> responseObs = this.storeModel.processMessage(request);
        return responseObs.map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class).getResource()).single();
    }
}

