/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.AccessConditionType;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ChangeFeedOptions;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.CosmosResourceType;
import com.azure.cosmos.DatabaseAccount;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.JsonSerializable;
import com.azure.cosmos.PartitionKey;
import com.azure.cosmos.PartitionKeyDefinition;
import com.azure.cosmos.Resource;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.TokenResolver;
import com.azure.cosmos.internal.AsyncDocumentClient;
import com.azure.cosmos.internal.AuthorizationTokenType;
import com.azure.cosmos.internal.BaseAuthorizationTokenProvider;
import com.azure.cosmos.internal.ChangeFeedQueryImpl;
import com.azure.cosmos.internal.Configs;
import com.azure.cosmos.internal.Conflict;
import com.azure.cosmos.internal.Database;
import com.azure.cosmos.internal.DatabaseAccountManagerInternal;
import com.azure.cosmos.internal.Document;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.GlobalEndpointManager;
import com.azure.cosmos.internal.IAuthorizationTokenProvider;
import com.azure.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.cosmos.internal.IRetryPolicyFactory;
import com.azure.cosmos.internal.ISessionContainer;
import com.azure.cosmos.internal.LifeCycleUtils;
import com.azure.cosmos.internal.ObservableHelper;
import com.azure.cosmos.internal.Offer;
import com.azure.cosmos.internal.OperationType;
import com.azure.cosmos.internal.PartitionKeyMismatchRetryPolicy;
import com.azure.cosmos.internal.PartitionKeyRange;
import com.azure.cosmos.internal.PathInfo;
import com.azure.cosmos.internal.PathParser;
import com.azure.cosmos.internal.PathsHelper;
import com.azure.cosmos.internal.Permission;
import com.azure.cosmos.internal.QueryCompatibilityMode;
import com.azure.cosmos.internal.RequestOptions;
import com.azure.cosmos.internal.ResetSessionTokenRetryPolicyFactory;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.ResourceTokenAuthorizationHelper;
import com.azure.cosmos.internal.ResourceType;
import com.azure.cosmos.internal.RetryPolicy;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.RxDocumentServiceResponse;
import com.azure.cosmos.internal.RxGatewayStoreModel;
import com.azure.cosmos.internal.RxStoreModel;
import com.azure.cosmos.internal.SessionContainer;
import com.azure.cosmos.internal.StoredProcedure;
import com.azure.cosmos.internal.StoredProcedureResponse;
import com.azure.cosmos.internal.Strings;
import com.azure.cosmos.internal.Trigger;
import com.azure.cosmos.internal.User;
import com.azure.cosmos.internal.UserAgentContainer;
import com.azure.cosmos.internal.UserDefinedFunction;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.caches.RxClientCollectionCache;
import com.azure.cosmos.internal.caches.RxCollectionCache;
import com.azure.cosmos.internal.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.internal.directconnectivity.GlobalAddressResolver;
import com.azure.cosmos.internal.directconnectivity.ServerStoreModel;
import com.azure.cosmos.internal.directconnectivity.StoreClient;
import com.azure.cosmos.internal.directconnectivity.StoreClientFactory;
import com.azure.cosmos.internal.http.HttpClient;
import com.azure.cosmos.internal.http.HttpClientConfig;
import com.azure.cosmos.internal.query.DocumentQueryExecutionContextFactory;
import com.azure.cosmos.internal.query.IDocumentQueryClient;
import com.azure.cosmos.internal.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.internal.query.Paginator;
import com.azure.cosmos.internal.routing.PartitionKeyAndResourceTokenPair;
import com.azure.cosmos.internal.routing.PartitionKeyInternal;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxDocumentClientImpl
implements AsyncDocumentClient,
IAuthorizationTokenProvider {
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();
    private final Logger logger = LoggerFactory.getLogger(RxDocumentClientImpl.class);
    private final String masterKeyOrResourceToken;
    private final URI serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel consistencyLevel;
    private final BaseAuthorizationTokenProvider authorizationTokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final boolean hasAuthKeyResourceToken;
    private final Configs configs;
    private CosmosKeyCredential cosmosKeyCredential;
    private TokenResolver tokenResolver;
    private SessionContainer sessionContainer;
    private String firstResourceTokenFromPermissionFeed = "";
    private RxClientCollectionCache collectionCache;
    private RxStoreModel gatewayProxy;
    private RxStoreModel storeModel;
    private GlobalAddressResolver addressResolver;
    private RxPartitionKeyRangeCache partitionKeyRangeCache;
    private Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap;
    private IRetryPolicyFactory resetSessionTokenRetryPolicy;
    private final QueryCompatibilityMode queryCompatibilityMode = QueryCompatibilityMode.Default;
    private final HttpClient reactorHttpClient;
    private final GlobalEndpointManager globalEndpointManager;
    private final RetryPolicy retryPolicy;
    private volatile boolean useMultipleWriteLocations;
    private StoreClientFactory storeClientFactory;
    private GatewayServiceConfigurationReader gatewayConfigurationReader;

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, TokenResolver tokenResolver, CosmosKeyCredential cosmosKeyCredential) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs, cosmosKeyCredential);
        this.tokenResolver = tokenResolver;
    }

    private RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosKeyCredential cosmosKeyCredential) {
        this(serviceEndpoint, masterKeyOrResourceToken, connectionPolicy, consistencyLevel, configs, cosmosKeyCredential);
        if (permissionFeed != null && permissionFeed.size() > 0) {
            this.resourceTokensMap = new HashMap<String, List<PartitionKeyAndResourceTokenPair>>();
            for (Permission permission : permissionFeed) {
                PartitionKey partitionKey;
                String[] segments = StringUtils.split((String)permission.getResourceLink(), (char)"/".charAt(0));
                if (segments.length <= 0) {
                    throw new IllegalArgumentException("resourceLink");
                }
                List<PartitionKeyAndResourceTokenPair> partitionKeyAndResourceTokenPairs = null;
                PathInfo pathInfo = new PathInfo(false, "", "", false);
                if (!PathsHelper.tryParsePathSegments(permission.getResourceLink(), pathInfo, null)) {
                    throw new IllegalArgumentException(permission.getResourceLink());
                }
                partitionKeyAndResourceTokenPairs = this.resourceTokensMap.get(pathInfo.resourceIdOrFullName);
                if (partitionKeyAndResourceTokenPairs == null) {
                    partitionKeyAndResourceTokenPairs = new ArrayList<PartitionKeyAndResourceTokenPair>();
                    this.resourceTokensMap.put(pathInfo.resourceIdOrFullName, partitionKeyAndResourceTokenPairs);
                }
                partitionKeyAndResourceTokenPairs.add(new PartitionKeyAndResourceTokenPair((partitionKey = permission.getResourcePartitionKey()) != null ? partitionKey.getInternalPartitionKey() : PartitionKeyInternal.Empty, permission.getToken()));
                this.logger.debug("Initializing resource token map  , with map key [{}] , partition key [{}] and resource token", new Object[]{pathInfo.resourceIdOrFullName, partitionKey != null ? partitionKey.toString() : null, permission.getToken()});
            }
            if (this.resourceTokensMap.isEmpty()) {
                throw new IllegalArgumentException("permissionFeed");
            }
            String firstToken = permissionFeed.get(0).getToken();
            if (ResourceTokenAuthorizationHelper.isResourceToken(firstToken)) {
                this.firstResourceTokenFromPermissionFeed = firstToken;
            }
        }
    }

    RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosKeyCredential cosmosKeyCredential) {
        this.logger.info("Initializing DocumentClient with serviceEndpoint [{}], connectionPolicy [{}], consistencyLevel [{}], directModeProtocol [{}]", new Object[]{serviceEndpoint, connectionPolicy, consistencyLevel, configs.getProtocol()});
        this.configs = configs;
        this.masterKeyOrResourceToken = masterKeyOrResourceToken;
        this.serviceEndpoint = serviceEndpoint;
        this.cosmosKeyCredential = cosmosKeyCredential;
        if (this.cosmosKeyCredential != null) {
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.cosmosKeyCredential);
        } else if (masterKeyOrResourceToken != null && ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
            this.authorizationTokenProvider = null;
            this.hasAuthKeyResourceToken = true;
        } else if (masterKeyOrResourceToken != null && !ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
            this.cosmosKeyCredential = new CosmosKeyCredential(this.masterKeyOrResourceToken);
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.cosmosKeyCredential);
        } else {
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = null;
        }
        this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy();
        this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost());
        this.consistencyLevel = consistencyLevel;
        this.userAgentContainer = new UserAgentContainer();
        String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
        if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
            this.userAgentContainer.setSuffix(userAgentSuffix);
        }
        this.reactorHttpClient = this.httpClient();
        this.globalEndpointManager = new GlobalEndpointManager(this.asDatabaseAccountManagerInternal(), this.connectionPolicy, configs);
        this.retryPolicy = new RetryPolicy(this.globalEndpointManager, this.connectionPolicy);
        this.resetSessionTokenRetryPolicy = this.retryPolicy;
    }

    private void initializeGatewayConfigurationReader() {
        String resourceToken;
        if (this.tokenResolver != null) {
            resourceToken = this.tokenResolver.getAuthorizationToken("GET", "", CosmosResourceType.System, null);
        } else if (!this.hasAuthKeyResourceToken && this.authorizationTokenProvider == null) {
            resourceToken = this.firstResourceTokenFromPermissionFeed;
        } else {
            assert (this.masterKeyOrResourceToken != null || this.cosmosKeyCredential != null);
            resourceToken = this.masterKeyOrResourceToken;
        }
        this.gatewayConfigurationReader = new GatewayServiceConfigurationReader(this.serviceEndpoint, this.hasAuthKeyResourceToken, resourceToken, this.connectionPolicy, this.authorizationTokenProvider, this.reactorHttpClient);
        DatabaseAccount databaseAccount = (DatabaseAccount)this.gatewayConfigurationReader.initializeReaderAsync().block();
        this.useMultipleWriteLocations = this.connectionPolicy.getUsingMultipleWriteLocations() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
        this.globalEndpointManager.refreshLocationAsync(databaseAccount).block();
    }

    public void init() {
        this.gatewayProxy = this.createRxGatewayProxy(this.sessionContainer, this.consistencyLevel, this.queryCompatibilityMode, this.userAgentContainer, this.globalEndpointManager, this.reactorHttpClient);
        this.globalEndpointManager.init();
        this.initializeGatewayConfigurationReader();
        this.collectionCache = new RxClientCollectionCache(this.sessionContainer, this.gatewayProxy, this, this.retryPolicy);
        this.resetSessionTokenRetryPolicy = new ResetSessionTokenRetryPolicyFactory(this.sessionContainer, this.collectionCache, this.retryPolicy);
        this.partitionKeyRangeCache = new RxPartitionKeyRangeCache(this, this.collectionCache);
        if (this.connectionPolicy.getConnectionMode() == ConnectionMode.GATEWAY) {
            this.storeModel = this.gatewayProxy;
        } else {
            this.initializeDirectConnectivity();
        }
    }

    private void initializeDirectConnectivity() {
        this.storeClientFactory = new StoreClientFactory(this.configs, this.connectionPolicy.getRequestTimeoutInMillis() / 1000, 0, this.userAgentContainer);
        this.addressResolver = new GlobalAddressResolver(this.reactorHttpClient, this.globalEndpointManager, this.configs.getProtocol(), this, this.collectionCache, this.partitionKeyRangeCache, this.userAgentContainer, null, this.connectionPolicy);
        this.createStoreModel(true);
    }

    DatabaseAccountManagerInternal asDatabaseAccountManagerInternal() {
        return new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return RxDocumentClientImpl.this.getServiceEndpoint();
            }

            @Override
            public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
                RxDocumentClientImpl.this.logger.info("Getting database account endpoint from {}", (Object)endpoint);
                return RxDocumentClientImpl.this.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return RxDocumentClientImpl.this.getConnectionPolicy();
            }
        };
    }

    RxGatewayStoreModel createRxGatewayProxy(ISessionContainer sessionContainer, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient) {
        return new RxGatewayStoreModel(sessionContainer, consistencyLevel, queryCompatibilityMode, userAgentContainer, globalEndpointManager, httpClient);
    }

    private HttpClient httpClient() {
        HttpClientConfig httpClientConfig = new HttpClientConfig(this.configs).withMaxIdleConnectionTimeoutInMillis(this.connectionPolicy.getIdleConnectionTimeoutInMillis()).withPoolSize(this.connectionPolicy.getMaxPoolSize()).withHttpProxy(this.connectionPolicy.getProxy()).withRequestTimeoutInMillis(this.connectionPolicy.getRequestTimeoutInMillis());
        return HttpClient.createFixed(httpClientConfig);
    }

    private void createStoreModel(boolean subscribeRntbdStatus) {
        StoreClient storeClient = this.storeClientFactory.createStoreClient(this.addressResolver, this.sessionContainer, this.gatewayConfigurationReader, this, false);
        this.storeModel = new ServerStoreModel(storeClient);
    }

    @Override
    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    @Override
    public URI getWriteEndpoint() {
        return this.globalEndpointManager.getWriteEndpoints().stream().findFirst().map(loc -> {
            try {
                return loc.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }).orElse(null);
    }

    @Override
    public URI getReadEndpoint() {
        return this.globalEndpointManager.getReadEndpoints().stream().findFirst().map(loc -> {
            try {
                return loc.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }).orElse(null);
    }

    @Override
    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public Flux<ResourceResponse<Database>> createDatabase(Database database, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDatabaseInternal(database, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Database>> createDatabaseInternal(Database database, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (database == null) {
                throw new IllegalArgumentException("Database");
            }
            this.logger.debug("Creating a Database. id: [{}]", (Object)database.getId());
            RxDocumentClientImpl.validateResource(database);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Create, ResourceType.Database, "/dbs", (Resource)database, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Database>> deleteDatabase(String databaseLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Database>> deleteDatabaseInternal(String databaseLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            this.logger.debug("Deleting a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Database>> readDatabase(String databaseLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Database>> readDatabaseInternal(String databaseLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            this.logger.debug("Reading a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Database>> readDatabases(FeedOptions options) {
        return this.readFeed(options, ResourceType.Database, Database.class, "/dbs");
    }

    private String parentResourceLinkToQueryLink(String parentResouceLink, ResourceType resourceTypeEnum) {
        switch (resourceTypeEnum) {
            case Database: {
                return "/dbs";
            }
            case DocumentCollection: {
                return Utils.joinPath(parentResouceLink, "colls");
            }
            case Document: {
                return Utils.joinPath(parentResouceLink, "docs");
            }
            case Offer: {
                return "/offers/";
            }
            case User: {
                return Utils.joinPath(parentResouceLink, "users");
            }
            case Permission: {
                return Utils.joinPath(parentResouceLink, "permissions");
            }
            case Attachment: {
                return Utils.joinPath(parentResouceLink, "attachments");
            }
            case StoredProcedure: {
                return Utils.joinPath(parentResouceLink, "sprocs");
            }
            case Trigger: {
                return Utils.joinPath(parentResouceLink, "triggers");
            }
            case UserDefinedFunction: {
                return Utils.joinPath(parentResouceLink, "udfs");
            }
        }
        throw new IllegalArgumentException("resource type not supported");
    }

    private <T extends Resource> Flux<FeedResponse<T>> createQuery(String parentResourceLink, SqlQuerySpec sqlQuery, FeedOptions options, Class<T> klass, ResourceType resourceTypeEnum) {
        String queryResourceLink = this.parentResourceLinkToQueryLink(parentResourceLink, resourceTypeEnum);
        UUID activityId = Utils.randomUUID();
        IDocumentQueryClient queryClient = this.DocumentQueryClientImpl(this);
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createDocumentQueryExecutionContextAsync(queryClient, resourceTypeEnum, klass, sqlQuery, options, queryResourceLink, false, activityId);
        return executionContext.flatMap(IDocumentQueryExecutionContext::executeAsync);
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(String query, FeedOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery("/dbs", querySpec, options, Database.class, ResourceType.Database);
    }

    @Override
    public Flux<ResourceResponse<DocumentCollection>> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createCollectionInternal(databaseLink, collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<DocumentCollection>> createCollectionInternal(String databaseLink, DocumentCollection collection, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            this.logger.debug("Creating a Collection. databaseLink: [{}], Collection id: [{}]", (Object)databaseLink, (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(databaseLink, "colls");
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Create, ResourceType.DocumentCollection, path, (Resource)collection, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders()));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection collection, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceCollectionInternal(collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<DocumentCollection>> replaceCollectionInternal(DocumentCollection collection, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            this.logger.debug("Replacing a Collection. id: [{}]", (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(collection.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.DocumentCollection, path, (Resource)collection, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> {
                if (resourceResponse.getResource() != null) {
                    this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders());
                }
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<DocumentCollection>> deleteCollection(String collectionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<DocumentCollection>> deleteCollectionInternal(String collectionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            this.logger.debug("Deleting a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    private Flux<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "DELETE");
        return this.getStoreProxy(request).processMessage(request);
    }

    private Flux<RxDocumentServiceResponse> read(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "GET");
        return this.getStoreProxy(request).processMessage(request);
    }

    Flux<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "GET");
        return this.gatewayProxy.processMessage(request);
    }

    private Flux<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "POST");
        return this.getStoreProxy(request).processMessage(request).map(response -> {
            this.captureSessionToken(request, (RxDocumentServiceResponse)response);
            return response;
        });
    }

    @Override
    public Flux<ResourceResponse<DocumentCollection>> readCollection(String collectionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<DocumentCollection>> readCollectionInternal(String collectionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            this.logger.debug("Reading a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> readCollections(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.DocumentCollection, DocumentCollection.class, Utils.joinPath(databaseLink, "colls"));
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, String query, FeedOptions options) {
        return this.createQuery(databaseLink, new SqlQuerySpec(query), options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(databaseLink, querySpec, options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    private static String serializeProcedureParams(Object[] objectArray) {
        Object[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof JsonSerializable) {
                stringArray[i] = ((JsonSerializable)object).toJson();
                continue;
            }
            try {
                stringArray[i] = mapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join((Object[])stringArray, (String)","));
    }

    private static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty((CharSequence)resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    private Map<String, String> getRequestHeaders(RequestOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.useMultipleWriteLocations) {
            headers.put("x-ms-cosmos-allow-tentative-writes", Boolean.TRUE.toString());
        }
        if (this.consistencyLevel != null) {
            headers.put("x-ms-consistency-level", this.consistencyLevel.toString());
        }
        if (options == null) {
            return headers;
        }
        Map<String, String> customOptions = options.getHeaders();
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        if (options.getAccessCondition() != null) {
            if (options.getAccessCondition().getType() == AccessConditionType.IF_MATCH) {
                headers.put("If-Match", options.getAccessCondition().getCondition());
            } else {
                headers.put("If-NONE-Match", options.getAccessCondition().getCondition());
            }
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().toString());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().toString());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join(options.getPostTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join(options.getPreTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (!Strings.isNullOrEmpty(options.getSessionToken())) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        if (options.getOfferThroughput() != null && options.getOfferThroughput() >= 0) {
            headers.put("x-ms-offer-throughput", options.getOfferThroughput().toString());
        } else if (options.getOfferType() != null) {
            headers.put("x-ms-offer-type", options.getOfferType());
        }
        if (options.isPopulateQuotaInfo()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        if (options.isScriptLoggingEnabled()) {
            headers.put("x-ms-documentdb-script-enable-logging", String.valueOf(true));
        }
        return headers;
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, Document document, RequestOptions options) {
        Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return collectionObs.map(collection -> {
            this.addPartitionKeyInformation(request, document, options, (DocumentCollection)collection);
            return request;
        });
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, Document document, RequestOptions options, Mono<DocumentCollection> collectionObs) {
        return collectionObs.map(collection -> {
            this.addPartitionKeyInformation(request, document, options, (DocumentCollection)collection);
            return request;
        });
    }

    private void addPartitionKeyInformation(RxDocumentServiceRequest request, Document document, RequestOptions options, DocumentCollection collection) {
        PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
        PartitionKeyInternal partitionKeyInternal = null;
        if (options != null && options.getPartitionKey() != null && options.getPartitionKey().equals(PartitionKey.None)) {
            partitionKeyInternal = BridgeInternal.getNonePartitionKey(partitionKeyDefinition);
        } else if (options != null && options.getPartitionKey() != null) {
            partitionKeyInternal = options.getPartitionKey().getInternalPartitionKey();
        } else if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            partitionKeyInternal = PartitionKeyInternal.getEmpty();
        } else if (document != null) {
            partitionKeyInternal = RxDocumentClientImpl.extractPartitionKeyValueFromDocument(document, partitionKeyDefinition);
        } else {
            throw new UnsupportedOperationException("PartitionKey value must be supplied for this operation.");
        }
        request.getHeaders().put("x-ms-documentdb-partitionkey", RxDocumentClientImpl.escapeNonAscii(partitionKeyInternal.toJson()));
    }

    private static String escapeNonAscii(String partitionKeyJson) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < partitionKeyJson.length(); ++i) {
            char val = partitionKeyJson.charAt(i);
            if (val > '\u007f') {
                sb.append("\\u").append(String.format("%04X", val));
                continue;
            }
            sb.append(partitionKeyJson.charAt(i));
        }
        return sb.toString();
    }

    private static PartitionKeyInternal extractPartitionKeyValueFromDocument(Document document, PartitionKeyDefinition partitionKeyDefinition) {
        String path;
        List<String> parts;
        if (partitionKeyDefinition != null && (parts = PathParser.getPathParts(path = partitionKeyDefinition.getPaths().iterator().next())).size() >= 1) {
            Object value = document.getObjectByPath(parts);
            if (value == null || value.getClass() == ObjectNode.class) {
                value = BridgeInternal.getNonePartitionKey(partitionKeyDefinition);
            }
            if (value instanceof PartitionKeyInternal) {
                return (PartitionKeyInternal)value;
            }
            return PartitionKeyInternal.fromObjectArray(Collections.singletonList(value), false);
        }
        return null;
    }

    private Mono<RxDocumentServiceRequest> getCreateDocumentRequest(String documentCollectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentCollectionLink)) {
            throw new IllegalArgumentException("documentCollectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Document typedDocument = BridgeInternal.documentFromObject(document, mapper);
        RxDocumentClientImpl.validateResource(typedDocument);
        if (typedDocument.getId() == null && !disableAutomaticIdGeneration) {
            typedDocument.setId(UUID.randomUUID().toString());
        }
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.Document, path, (Resource)typedDocument, requestHeaders, (Object)options);
        Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return this.addPartitionKeyInformation(request, typedDocument, options, collectionObs);
    }

    private void populateHeaders(RxDocumentServiceRequest request, String httpMethod) {
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (this.masterKeyOrResourceToken != null || this.resourceTokensMap != null || this.tokenResolver != null || this.cosmosKeyCredential != null) {
            String resourceName = request.getResourceAddress();
            String authorization = this.getUserAuthorizationToken(resourceName, request.getResourceType(), httpMethod, request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, request.properties);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if (("POST".equals(httpMethod) || "PUT".equals(httpMethod)) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
    }

    @Override
    public String getUserAuthorizationToken(String resourceName, ResourceType resourceType, String requestVerb, Map<String, String> headers, AuthorizationTokenType tokenType, Map<String, Object> properties) {
        if (this.tokenResolver != null) {
            return this.tokenResolver.getAuthorizationToken(requestVerb, resourceName, this.resolveCosmosResourceType(resourceType), properties != null ? Collections.unmodifiableMap(properties) : null);
        }
        if (this.cosmosKeyCredential != null) {
            return this.authorizationTokenProvider.generateKeyAuthorizationSignature(requestVerb, resourceName, resourceType, headers);
        }
        if (this.masterKeyOrResourceToken != null && this.hasAuthKeyResourceToken && this.resourceTokensMap == null) {
            return this.masterKeyOrResourceToken;
        }
        assert (this.resourceTokensMap != null);
        if (resourceType.equals((Object)ResourceType.DatabaseAccount)) {
            return this.firstResourceTokenFromPermissionFeed;
        }
        return ResourceTokenAuthorizationHelper.getAuthorizationTokenUsingResourceTokens(this.resourceTokensMap, requestVerb, resourceName, headers);
    }

    private CosmosResourceType resolveCosmosResourceType(ResourceType resourceType) {
        try {
            return CosmosResourceType.valueOf(resourceType.toString());
        }
        catch (IllegalArgumentException e) {
            return CosmosResourceType.System;
        }
    }

    void captureSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        this.sessionContainer.setSessionToken(request, response.getResponseHeaders());
    }

    private Flux<RxDocumentServiceResponse> create(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "POST");
        RxStoreModel storeProxy = this.getStoreProxy(request);
        return storeProxy.processMessage(request);
    }

    private Flux<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "POST");
        Map<String, String> headers = request.getHeaders();
        assert (headers != null);
        headers.put("x-ms-documentdb-is-upsert", "true");
        return this.getStoreProxy(request).processMessage(request).map(response -> {
            this.captureSessionToken(request, (RxDocumentServiceResponse)response);
            return response;
        });
    }

    private Flux<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "PUT");
        return this.getStoreProxy(request).processMessage(request);
    }

    @Override
    public Flux<ResourceResponse<Document>> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), requestRetryPolicy);
    }

    private Flux<ResourceResponse<Document>> createDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, IDocumentClientRetryPolicy requestRetryPolicy) {
        try {
            this.logger.debug("Creating a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<RxDocumentServiceRequest> requestObs = this.getCreateDocumentRequest(collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Create);
            Flux responseObservable = requestObs.flux().flatMap(req -> {
                if (requestRetryPolicy != null) {
                    requestRetryPolicy.onBeforeSendRequest((RxDocumentServiceRequest)req);
                }
                return this.create((RxDocumentServiceRequest)req);
            });
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Document>> upsertDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), requestRetryPolicy);
    }

    private Flux<ResourceResponse<Document>> upsertDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Document. collectionLink: [{}]", (Object)collectionLink);
            Flux reqObs = this.getCreateDocumentRequest(collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Upsert).flux();
            Flux responseObservable = reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
                }
                return this.upsert((RxDocumentServiceRequest)req);
            });
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Document>> replaceDocument(String documentLink, Object document, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = Utils.getCollectionName(documentLink);
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(documentLink, document, options, finalRequestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Object document, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            Document typedDocument = BridgeInternal.documentFromObject(document, mapper);
            return this.replaceDocumentInternal(documentLink, typedDocument, options, retryPolicyInstance);
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a document due to [{}]", (Object)e.getMessage());
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Document>> replaceDocument(Document document, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = document.getSelfLink();
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(document, options, finalRequestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<Document>> replaceDocumentInternal(Document document, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            return this.replaceDocumentInternal(document.getSelfLink(), document, options, retryPolicyInstance);
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a database due to [{}]", (Object)e.getMessage());
            return Flux.error((Throwable)e);
        }
    }

    private Flux<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Document document, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        this.logger.debug("Replacing a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Document, path, (Resource)document, requestHeaders, (Object)options);
        RxDocumentClientImpl.validateResource(document);
        Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
        Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, document, options, collectionObs);
        return requestObs.flux().flatMap(req -> {
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(resp -> BridgeInternal.toResourceResponse(resp, Document.class));
        });
    }

    @Override
    public Flux<ResourceResponse<Document>> deleteDocument(String documentLink, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDocumentInternal(documentLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<Document>> deleteDocumentInternal(String documentLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            this.logger.debug("Deleting a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Document, path, requestHeaders, options);
            Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, options, collectionObs);
            return requestObs.flux().flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
                }
                return this.delete((RxDocumentServiceRequest)req).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a document due to [{}]", (Object)e.getMessage());
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Document>> readDocument(String documentLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDocumentInternal(documentLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Document>> readDocumentInternal(String documentLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            this.logger.debug("Reading a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Document, path, requestHeaders, options);
            Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, options, collectionObs);
            return requestObs.flux().flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a document due to [{}]", (Object)e.getMessage());
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Document>> readDocuments(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.queryDocuments(collectionLink, "SELECT * FROM r", options);
    }

    @Override
    public Flux<FeedResponse<Document>> queryDocuments(String collectionLink, String query, FeedOptions options) {
        return this.queryDocuments(collectionLink, new SqlQuerySpec(query), options);
    }

    private IDocumentQueryClient DocumentQueryClientImpl(RxDocumentClientImpl rxDocumentClientImpl) {
        return new IDocumentQueryClient(){

            @Override
            public RxCollectionCache getCollectionCache() {
                return RxDocumentClientImpl.this.collectionCache;
            }

            @Override
            public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
                return RxDocumentClientImpl.this.partitionKeyRangeCache;
            }

            @Override
            public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
                return RxDocumentClientImpl.this.resetSessionTokenRetryPolicy;
            }

            @Override
            public ConsistencyLevel getDefaultConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.gatewayConfigurationReader.getDefaultConsistencyLevel();
            }

            @Override
            public ConsistencyLevel getDesiredConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.consistencyLevel;
            }

            @Override
            public Mono<RxDocumentServiceResponse> executeQueryAsync(RxDocumentServiceRequest request) {
                return RxDocumentClientImpl.this.query(request).single();
            }

            @Override
            public IDocumentQueryClient.QueryCompatibilityMode getQueryCompatibilityMode() {
                return IDocumentQueryClient.QueryCompatibilityMode.Default;
            }

            @Override
            public Mono<RxDocumentServiceResponse> readFeedAsync(RxDocumentServiceRequest request) {
                return null;
            }
        };
    }

    @Override
    public Flux<FeedResponse<Document>> queryDocuments(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Document.class, ResourceType.Document);
    }

    @Override
    public Flux<FeedResponse<Document>> queryDocumentChangeFeed(String collectionLink, ChangeFeedOptions changeFeedOptions) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        ChangeFeedQueryImpl<Document> changeFeedQueryImpl = new ChangeFeedQueryImpl<Document>(this, ResourceType.Document, Document.class, collectionLink, changeFeedOptions);
        return changeFeedQueryImpl.executeAsync();
    }

    @Override
    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.PartitionKeyRange, PartitionKeyRange.class, Utils.joinPath(collectionLink, "pkranges"));
    }

    private RxDocumentServiceRequest getStoredProcedureRequest(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        RxDocumentClientImpl.validateResource(storedProcedure);
        String path = Utils.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
        return request;
    }

    private RxDocumentServiceRequest getUserDefinedFunctionRequest(String collectionLink, UserDefinedFunction udf, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        RxDocumentClientImpl.validateResource(udf);
        String path = Utils.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Flux<ResourceResponse<StoredProcedure>> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<StoredProcedure>> createStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<StoredProcedure>> upsertStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceStoredProcedureInternal(storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<StoredProcedure>> replaceStoredProcedureInternal(StoredProcedure storedProcedure, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (storedProcedure == null) {
                throw new IllegalArgumentException("storedProcedure");
            }
            this.logger.debug("Replacing a StoredProcedure. storedProcedure id [{}]", (Object)storedProcedure.getId());
            RxDocumentClientImpl.validateResource(storedProcedure);
            String path = Utils.joinPath(storedProcedure.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteStoredProcedureInternal(storedProcedureLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Flux<ResourceResponse<StoredProcedure>> deleteStoredProcedureInternal(String storedProcedureLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            this.logger.debug("Deleting a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<StoredProcedure>> readStoredProcedure(String storedProcedureLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readStoredProcedureInternal(storedProcedureLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<StoredProcedure>> readStoredProcedureInternal(String storedProcedureLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            this.logger.debug("Reading a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> readStoredProcedures(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.StoredProcedure, StoredProcedure.class, Utils.joinPath(collectionLink, "sprocs"));
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, String query, FeedOptions options) {
        return this.queryStoredProcedures(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, StoredProcedure.class, ResourceType.StoredProcedure);
    }

    @Override
    public Flux<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, Object[] procedureParams) {
        return this.executeStoredProcedure(storedProcedureLink, null, procedureParams);
    }

    @Override
    public Flux<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, RequestOptions options, Object[] procedureParams) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.executeStoredProcedureInternal(storedProcedureLink, options, procedureParams), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Flux<StoredProcedureResponse> executeStoredProcedureInternal(String storedProcedureLink, RequestOptions options, Object[] procedureParams) {
        try {
            this.logger.debug("Executing a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            requestHeaders.put("Accept", "application/json");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ExecuteJavaScript, ResourceType.StoredProcedure, path, procedureParams != null ? RxDocumentClientImpl.serializeProcedureParams(procedureParams) : "", requestHeaders, (Object)options);
            Flux reqObs = this.addPartitionKeyInformation(request, null, options).flux();
            return reqObs.flatMap(req -> this.create(request).map(response -> {
                this.captureSessionToken(request, (RxDocumentServiceResponse)response);
                return BridgeInternal.toStoredProcedureResponse(response);
            }));
        }
        catch (Exception e) {
            this.logger.debug("Failure in executing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Trigger>> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Trigger>> createTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Trigger>> upsertTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Trigger>> upsertTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getTriggerRequest(String collectionLink, Trigger trigger, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        RxDocumentClientImpl.validateResource(trigger);
        String path = Utils.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Flux<ResourceResponse<Trigger>> replaceTrigger(Trigger trigger, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceTriggerInternal(trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Trigger>> replaceTriggerInternal(Trigger trigger, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (trigger == null) {
                throw new IllegalArgumentException("trigger");
            }
            this.logger.debug("Replacing a Trigger. trigger id [{}]", (Object)trigger.getId());
            RxDocumentClientImpl.validateResource(trigger);
            String path = Utils.joinPath(trigger.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Trigger>> deleteTrigger(String triggerLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Trigger>> deleteTriggerInternal(String triggerLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            this.logger.debug("Deleting a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Trigger>> readTrigger(String triggerLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Trigger>> readTriggerInternal(String triggerLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            this.logger.debug("Reading a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Trigger>> readTriggers(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Trigger, Trigger.class, Utils.joinPath(collectionLink, "triggers"));
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, String query, FeedOptions options) {
        return this.queryTriggers(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Trigger.class, ResourceType.Trigger);
    }

    @Override
    public Flux<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<UserDefinedFunction>> createUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserDefinedFunctionInternal(udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunctionInternal(UserDefinedFunction udf, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (udf == null) {
                throw new IllegalArgumentException("udf");
            }
            this.logger.debug("Replacing a UserDefinedFunction. udf id [{}]", (Object)udf.getId());
            RxDocumentClientImpl.validateResource(udf);
            String path = Utils.joinPath(udf.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String udfLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunctionInternal(String udfLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            this.logger.debug("Deleting a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String udfLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<UserDefinedFunction>> readUserDefinedFunctionInternal(String udfLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            this.logger.debug("Reading a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.UserDefinedFunction, UserDefinedFunction.class, Utils.joinPath(collectionLink, "udfs"));
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, String query, FeedOptions options) {
        return this.queryUserDefinedFunctions(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, UserDefinedFunction.class, ResourceType.UserDefinedFunction);
    }

    @Override
    public Flux<ResourceResponse<Conflict>> readConflict(String conflictLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Conflict>> readConflictInternal(String conflictLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            this.logger.debug("Reading a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Conflict, path, requestHeaders, options);
            Flux reqObs = this.addPartitionKeyInformation(request, null, options).flux();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Conflict>> readConflicts(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Conflict, Conflict.class, Utils.joinPath(collectionLink, "conflicts"));
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, String query, FeedOptions options) {
        return this.queryConflicts(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Conflict.class, ResourceType.Conflict);
    }

    @Override
    public Flux<ResourceResponse<Conflict>> deleteConflict(String conflictLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Conflict>> deleteConflictInternal(String conflictLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            this.logger.debug("Deleting a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Conflict, path, requestHeaders, options);
            Flux reqObs = this.addPartitionKeyInformation(request, null, options).flux();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<User>> createUser(String databaseLink, User user, RequestOptions options) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserInternal(databaseLink, user, options), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Flux<ResourceResponse<User>> createUserInternal(String databaseLink, User user, RequestOptions options) {
        try {
            this.logger.debug("Creating a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Create);
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<User>> upsertUser(String databaseLink, User user, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserInternal(databaseLink, user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<User>> upsertUserInternal(String databaseLink, User user, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getUserRequest(String databaseLink, User user, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        RxDocumentClientImpl.validateResource(user);
        String path = Utils.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Flux<ResourceResponse<User>> replaceUser(User user, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserInternal(user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<User>> replaceUserInternal(User user, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (user == null) {
                throw new IllegalArgumentException("user");
            }
            this.logger.debug("Replacing a User. user id [{}]", (Object)user.getId());
            RxDocumentClientImpl.validateResource(user);
            String path = Utils.joinPath(user.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<User>> deleteUser(String userLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<User>> deleteUserInternal(String userLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            this.logger.debug("Deleting a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<User>> readUser(String userLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<User>> readUserInternal(String userLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            this.logger.debug("Reading a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<User>> readUsers(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.User, User.class, Utils.joinPath(databaseLink, "users"));
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, String query, FeedOptions options) {
        return this.queryUsers(databaseLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(databaseLink, querySpec, options, User.class, ResourceType.User);
    }

    @Override
    public Flux<ResourceResponse<Permission>> createPermission(String userLink, Permission permission, RequestOptions options) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createPermissionInternal(userLink, permission, options), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Flux<ResourceResponse<Permission>> createPermissionInternal(String userLink, Permission permission, RequestOptions options) {
        try {
            this.logger.debug("Creating a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Create);
            return this.create(request).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Permission>> upsertPermission(String userLink, Permission permission, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertPermissionInternal(userLink, permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Permission>> upsertPermissionInternal(String userLink, Permission permission, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getPermissionRequest(String userLink, Permission permission, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        RxDocumentClientImpl.validateResource(permission);
        String path = Utils.joinPath(userLink, "permissions");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(operationType, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Flux<ResourceResponse<Permission>> replacePermission(Permission permission, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replacePermissionInternal(permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Permission>> replacePermissionInternal(Permission permission, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (permission == null) {
                throw new IllegalArgumentException("permission");
            }
            this.logger.debug("Replacing a Permission. permission id [{}]", (Object)permission.getId());
            RxDocumentClientImpl.validateResource(permission);
            String path = Utils.joinPath(permission.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Permission>> deletePermission(String permissionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deletePermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Permission>> deletePermissionInternal(String permissionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            this.logger.debug("Deleting a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Delete, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Permission>> readPermission(String permissionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readPermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Permission>> readPermissionInternal(String permissionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            this.logger.debug("Reading a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Permission>> readPermissions(String userLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        return this.readFeed(options, ResourceType.Permission, Permission.class, Utils.joinPath(userLink, "permissions"));
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, String query, FeedOptions options) {
        return this.queryPermissions(userLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(userLink, querySpec, options, Permission.class, ResourceType.Permission);
    }

    @Override
    public Flux<ResourceResponse<Offer>> replaceOffer(Offer offer) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceOfferInternal(offer), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Flux<ResourceResponse<Offer>> replaceOfferInternal(Offer offer) {
        try {
            if (offer == null) {
                throw new IllegalArgumentException("offer");
            }
            this.logger.debug("Replacing an Offer. offer id [{}]", (Object)offer.getId());
            RxDocumentClientImpl.validateResource(offer);
            String path = Utils.joinPath(offer.getSelfLink(), null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Replace, ResourceType.Offer, path, (Resource)offer, null, null);
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<ResourceResponse<Offer>> readOffer(String offerLink) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readOfferInternal(offerLink, retryPolicyInstance), retryPolicyInstance);
    }

    private Flux<ResourceResponse<Offer>> readOfferInternal(String offerLink, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)offerLink)) {
                throw new IllegalArgumentException("offerLink");
            }
            this.logger.debug("Reading an Offer. offerLink [{}]", (Object)offerLink);
            String path = Utils.joinPath(offerLink, null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.Offer, path, (Map<String, String>)null, null);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Offer>> readOffers(FeedOptions options) {
        return this.readFeed(options, ResourceType.Offer, Offer.class, Utils.joinPath("offers", null));
    }

    private <T extends Resource> Flux<FeedResponse<T>> readFeedCollectionChild(FeedOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        if (options == null) {
            options = new FeedOptions();
        }
        int maxPageSize = options.maxItemCount() != null ? options.maxItemCount() : -1;
        FeedOptions finalFeedOptions = options;
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setPartitionKey(options.partitionKey());
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ReadFeed, resourceType, resourceLink, requestHeaders, finalFeedOptions);
            return request;
        };
        Function executeFunc = request -> ObservableHelper.inlineIfPossibleAsObs(() -> {
            Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync((RxDocumentServiceRequest)request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation((RxDocumentServiceRequest)request, null, requestOptions, collectionObs);
            return requestObs.flux().flatMap(req -> this.readFeed((RxDocumentServiceRequest)req).map(response -> BridgeInternal.toFeedResponsePage(response, klass)));
        }, this.resetSessionTokenRetryPolicy.getRequestPolicy());
        return Paginator.getPaginatedQueryResultAsObservable(options, createRequestFunc, executeFunc, klass, maxPageSize);
    }

    private <T extends Resource> Flux<FeedResponse<T>> readFeed(FeedOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        if (options == null) {
            options = new FeedOptions();
        }
        int maxPageSize = options.maxItemCount() != null ? options.maxItemCount() : -1;
        FeedOptions finalFeedOptions = options;
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ReadFeed, resourceType, resourceLink, requestHeaders, finalFeedOptions);
            return request;
        };
        Function executeFunc = request -> ObservableHelper.inlineIfPossibleAsObs(() -> this.readFeed((RxDocumentServiceRequest)request).map(response -> BridgeInternal.toFeedResponsePage(response, klass)), this.resetSessionTokenRetryPolicy.getRequestPolicy());
        return Paginator.getPaginatedQueryResultAsObservable(options, createRequestFunc, executeFunc, klass, maxPageSize);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(String query, FeedOptions options) {
        return this.queryOffers(new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(null, querySpec, options, Offer.class, ResourceType.Offer);
    }

    @Override
    public Flux<DatabaseAccount> getDatabaseAccount() {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getDatabaseAccountInternal(), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Flux<DatabaseAccount> getDatabaseAccountInternal() {
        try {
            this.logger.debug("Getting Database Account");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DatabaseAccount, "", (Map<String, String>)null, null);
            return this.read(request).map(response -> BridgeInternal.toDatabaseAccount(response));
        }
        catch (Exception e) {
            this.logger.debug("Failure in getting Database Account due to [{}]", (Object)e.getMessage(), (Object)e);
            return Flux.error((Throwable)e);
        }
    }

    public Object getSession() {
        return this.sessionContainer;
    }

    public void setSession(Object sessionContainer) {
        this.sessionContainer = (SessionContainer)sessionContainer;
    }

    public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
        return Flux.defer(() -> {
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DatabaseAccount, "", null, null);
            this.populateHeaders(request, "GET");
            request.setEndpointOverride(endpoint);
            return this.gatewayProxy.processMessage(request).doOnError(e -> {
                String message = String.format("Failed to retrieve database account information. %s", e.getCause() != null ? e.getCause().toString() : e.toString());
                this.logger.warn(message);
            }).map(rsp -> rsp.getResource(DatabaseAccount.class)).doOnNext(databaseAccount -> {
                this.useMultipleWriteLocations = this.connectionPolicy.getUsingMultipleWriteLocations() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
            });
        });
    }

    private RxStoreModel getStoreProxy(RxDocumentServiceRequest request) {
        if (request.UseGatewayMode) {
            return this.gatewayProxy;
        }
        ResourceType resourceType = request.getResourceType();
        OperationType operationType = request.getOperationType();
        if (resourceType == ResourceType.Offer || resourceType.isScript() && operationType != OperationType.ExecuteJavaScript || resourceType == ResourceType.PartitionKeyRange) {
            return this.gatewayProxy;
        }
        if (operationType == OperationType.Create || operationType == OperationType.Upsert) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.Permission) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Delete) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Replace) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Read) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if ((request.getOperationType() == OperationType.Query || request.getOperationType() == OperationType.SqlQuery) && Utils.isCollectionChild(request.getResourceType()) && request.getPartitionKeyRangeIdentity() == null) {
            return this.gatewayProxy;
        }
        return this.storeModel;
    }

    @Override
    public void close() {
        this.logger.info("Shutting down ...");
        LifeCycleUtils.closeQuietly(this.globalEndpointManager);
        LifeCycleUtils.closeQuietly(this.storeClientFactory);
        try {
            this.reactorHttpClient.shutdown();
        }
        catch (Exception e) {
            this.logger.warn("Failure in shutting down reactorHttpClient", (Throwable)e);
        }
    }
}

