/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.RetryOptions;
import com.azure.cosmos.internal.ClientRetryPolicy;
import com.azure.cosmos.internal.GlobalEndpointManager;
import com.azure.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.cosmos.internal.IRetryPolicyFactory;

public class RetryPolicy
implements IRetryPolicyFactory {
    private final GlobalEndpointManager globalEndpointManager;
    private final boolean enableEndpointDiscovery;
    private final RetryOptions retryOptions;

    public RetryPolicy(GlobalEndpointManager globalEndpointManager, ConnectionPolicy connectionPolicy) {
        this.enableEndpointDiscovery = connectionPolicy.getEnableEndpointDiscovery();
        this.globalEndpointManager = globalEndpointManager;
        this.retryOptions = connectionPolicy.getRetryOptions();
    }

    @Override
    public IDocumentClientRetryPolicy getRequestPolicy() {
        ClientRetryPolicy clientRetryPolicy = new ClientRetryPolicy(this.globalEndpointManager, this.enableEndpointDiscovery, this.retryOptions);
        return clientRetryPolicy;
    }
}

