/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.Exceptions;
import com.azure.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.cosmos.internal.IRetryPolicy;
import com.azure.cosmos.internal.OperationType;
import com.azure.cosmos.internal.ResourceType;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.internal.caches.RxCollectionCache;
import com.azure.cosmos.internal.routing.CollectionRoutingMap;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class PartitionKeyRangeGoneRetryPolicy
implements IDocumentClientRetryPolicy {
    private final RxCollectionCache collectionCache;
    private final IDocumentClientRetryPolicy nextRetryPolicy;
    private final IPartitionKeyRangeCache partitionKeyRangeCache;
    private final String collectionLink;
    private final FeedOptions feedOptions;
    private volatile boolean retried;

    public PartitionKeyRangeGoneRetryPolicy(RxCollectionCache collectionCache, IPartitionKeyRangeCache partitionKeyRangeCache, String collectionLink, IDocumentClientRetryPolicy nextRetryPolicy, FeedOptions feedOptions) {
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.collectionLink = collectionLink;
        this.nextRetryPolicy = nextRetryPolicy;
        this.feedOptions = feedOptions;
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        CosmosClientException clientException = Utils.as(exception, CosmosClientException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 410) && Exceptions.isSubStatusCode(clientException, 1002)) {
            if (this.retried) {
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(clientException));
            }
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, this.collectionLink, null);
            if (this.feedOptions != null) {
                request.properties = this.feedOptions.properties();
            }
            Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
            return collectionObs.flatMap(collection -> {
                Mono<CollectionRoutingMap> routingMapObs = this.partitionKeyRangeCache.tryLookupAsync(collection.getResourceId(), null, request.properties);
                Mono refreshedRoutingMapObs = routingMapObs.flatMap(routingMap -> this.partitionKeyRangeCache.tryLookupAsync(collection.getResourceId(), (CollectionRoutingMap)routingMap, request.properties)).switchIfEmpty(Mono.defer(Mono::empty));
                return refreshedRoutingMapObs.flatMap(rm -> {
                    this.retried = true;
                    return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
                }).switchIfEmpty(Mono.defer(() -> {
                    this.retried = true;
                    return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
                }));
            });
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }
}

