/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.Resource;
import com.azure.cosmos.internal.Utils;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Offer
extends Resource {
    public Offer(int offerThroughput) {
        this.setOfferVersion("V2");
        this.setOfferType("");
        ObjectNode content = Utils.getSimpleObjectMapper().createObjectNode();
        content.put("offerThroughput", offerThroughput);
        this.setContent(content);
    }

    public Offer(String jsonString) {
        super(jsonString);
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    void setResourceLink(String resourceLink) {
        BridgeInternal.setProperty(this, "resource", resourceLink);
    }

    public String getOfferResourceId() {
        return super.getString("offerResourceId");
    }

    void setOfferResourceId(String resourceId) {
        BridgeInternal.setProperty(this, "offerResourceId", resourceId);
    }

    public String getOfferType() {
        return super.getString("offerType");
    }

    public void setOfferType(String offerType) {
        BridgeInternal.setProperty(this, "offerType", offerType);
    }

    public String getOfferVersion() {
        return super.getString("offerVersion");
    }

    public void setOfferVersion(String offerVersion) {
        BridgeInternal.setProperty(this, "offerVersion", offerVersion);
    }

    public int getThroughput() {
        return this.getContent().get("offerThroughput").asInt();
    }

    public void setThroughput(int throughput) {
        this.getContent().put("offerThroughput", throughput);
    }

    private ObjectNode getContent() {
        return BridgeInternal.getObject(this, "content");
    }

    private void setContent(ObjectNode offerContent) {
        BridgeInternal.setProperty(this, "content", offerContent);
    }
}

