/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.internal.Exceptions;
import com.azure.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.cosmos.internal.IRetryPolicy;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.caches.RxCollectionCache;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class InvalidPartitionExceptionRetryPolicy
implements IDocumentClientRetryPolicy {
    private final RxCollectionCache clientCollectionCache;
    private final IDocumentClientRetryPolicy nextPolicy;
    private final String collectionLink;
    private final FeedOptions feedOptions;
    private volatile boolean retried = false;

    public InvalidPartitionExceptionRetryPolicy(RxCollectionCache collectionCache, IDocumentClientRetryPolicy nextPolicy, String resourceFullName, FeedOptions feedOptions) {
        this.clientCollectionCache = collectionCache;
        this.nextPolicy = nextPolicy;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.feedOptions = feedOptions;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        CosmosClientException clientException = Utils.as(e, CosmosClientException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 410) && Exceptions.isSubStatusCode(clientException, 1000)) {
            if (!this.retried) {
                if (this.feedOptions != null) {
                    this.clientCollectionCache.refresh(this.collectionLink, this.feedOptions.properties());
                } else {
                    this.clientCollectionCache.refresh(this.collectionLink, null);
                }
                this.retried = true;
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
            }
            return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
        }
        return this.nextPolicy.shouldRetry(e);
    }
}

