/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.DatabaseAccount;
import com.azure.cosmos.internal.Configs;
import com.azure.cosmos.internal.DatabaseAccountManagerInternal;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.routing.LocationCache;
import com.azure.cosmos.internal.routing.LocationHelper;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class GlobalEndpointManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private final int backgroundRefreshLocationTimeIntervalInMS;
    private final LocationCache locationCache;
    private final URL defaultEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final DatabaseAccountManagerInternal owner;
    private final AtomicBoolean isRefreshing;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Scheduler scheduler = Schedulers.fromExecutor((Executor)this.executor);
    private volatile boolean isClosed;

    public GlobalEndpointManager(DatabaseAccountManagerInternal owner, ConnectionPolicy connectionPolicy, Configs configs) {
        this.backgroundRefreshLocationTimeIntervalInMS = configs.getUnavailableLocationsExpirationTimeInSeconds() * 1000;
        try {
            this.locationCache = new LocationCache(new ArrayList<String>(connectionPolicy.getPreferredLocations() != null ? connectionPolicy.getPreferredLocations() : Collections.emptyList()), owner.getServiceEndpoint().toURL(), connectionPolicy.getEnableEndpointDiscovery(), BridgeInternal.getUseMultipleWriteLocations(connectionPolicy), configs);
            this.owner = owner;
            this.defaultEndpoint = owner.getServiceEndpoint().toURL();
            this.connectionPolicy = connectionPolicy;
            this.isRefreshing = new AtomicBoolean(false);
            this.isClosed = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void init() {
        this.startRefreshLocationTimerAsync(true).block();
    }

    public UnmodifiableList<URL> getReadEndpoints() {
        return this.locationCache.getReadEndpoints();
    }

    public UnmodifiableList<URL> getWriteEndpoints() {
        return this.locationCache.getWriteEndpoints();
    }

    public static Mono<DatabaseAccount> getDatabaseAccountFromAnyLocationsAsync(URL defaultEndpoint, List<String> locations, Function<URL, Mono<DatabaseAccount>> getDatabaseAccountFn) {
        return getDatabaseAccountFn.apply(defaultEndpoint).onErrorResume(e -> {
            logger.error("Fail to reach global gateway [{}], [{}]", (Object)defaultEndpoint, (Object)e.getMessage());
            if (locations.isEmpty()) {
                return Mono.error((Throwable)e);
            }
            Flux obs = Flux.range((int)0, (int)locations.size()).map(index -> ((Mono)getDatabaseAccountFn.apply(LocationHelper.getLocationEndpoint(defaultEndpoint, (String)locations.get((int)index)))).flux());
            Mono res = Flux.concatDelayError((Publisher)obs).take(1L).single();
            return res.doOnError(innerE -> logger.error("Fail to reach location any of locations {} {}", (Object)String.join((CharSequence)",", locations), (Object)innerE.getMessage()));
        });
    }

    public URL resolveServiceEndpoint(RxDocumentServiceRequest request) {
        return this.locationCache.resolveServiceEndpoint(request);
    }

    public void markEndpointUnavailableForRead(URL endpoint) {
        logger.debug("Marking endpoint {} unavailable for read", (Object)endpoint);
        this.locationCache.markEndpointUnavailableForRead(endpoint);
    }

    public void markEndpointUnavailableForWrite(URL endpoint) {
        logger.debug("Marking  endpoint {} unavailable for Write", (Object)endpoint);
        this.locationCache.markEndpointUnavailableForWrite(endpoint);
    }

    public boolean CanUseMultipleWriteLocations(RxDocumentServiceRequest request) {
        return this.locationCache.canUseMultipleWriteLocations(request);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.executor.shutdown();
        logger.debug("GlobalEndpointManager closed.");
    }

    public Mono<Void> refreshLocationAsync(DatabaseAccount databaseAccount) {
        return Mono.defer(() -> {
            logger.debug("refreshLocationAsync() invoked");
            if (!this.isRefreshing.compareAndSet(false, true)) {
                logger.debug("in the middle of another refresh. Not invoking a new refresh.");
                return Mono.empty();
            }
            logger.debug("will refresh");
            return this.refreshLocationPrivateAsync(databaseAccount).doOnError(e -> this.isRefreshing.set(false));
        });
    }

    private Mono<Void> refreshLocationPrivateAsync(DatabaseAccount databaseAccount) {
        return Mono.defer(() -> {
            Utils.ValueHolder canRefreshInBackground;
            logger.debug("refreshLocationPrivateAsync() refreshing locations");
            if (databaseAccount != null) {
                this.locationCache.onDatabaseAccountRead(databaseAccount);
            }
            if (this.locationCache.shouldRefreshEndpoints(canRefreshInBackground = new Utils.ValueHolder())) {
                logger.debug("shouldRefreshEndpoints: true");
                if (databaseAccount == null && !((Boolean)canRefreshInBackground.v).booleanValue()) {
                    logger.debug("shouldRefreshEndpoints: can't be done in background");
                    Mono<DatabaseAccount> databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.connectionPolicy.getPreferredLocations()), this::getDatabaseAccountAsync);
                    return databaseAccountObs.map(dbAccount -> {
                        this.locationCache.onDatabaseAccountRead((DatabaseAccount)dbAccount);
                        return dbAccount;
                    }).flatMap(dbAccount -> {
                        this.startRefreshLocationTimerAsync();
                        return Mono.empty();
                    });
                }
                this.startRefreshLocationTimerAsync();
                return Mono.empty();
            }
            logger.debug("shouldRefreshEndpoints: false, nothing to do.");
            this.isRefreshing.set(false);
            return Mono.empty();
        });
    }

    private void startRefreshLocationTimerAsync() {
        this.startRefreshLocationTimerAsync(false).subscribe();
    }

    private Mono<Void> startRefreshLocationTimerAsync(boolean initialization) {
        if (this.isClosed) {
            logger.debug("startRefreshLocationTimerAsync: nothing to do, it is closed");
            return Mono.empty();
        }
        logger.debug("registering a refresh in [{}] ms", (Object)this.backgroundRefreshLocationTimeIntervalInMS);
        LocalDateTime now = LocalDateTime.now();
        int delayInMillis = initialization ? 0 : this.backgroundRefreshLocationTimeIntervalInMS;
        return Mono.delay((Duration)Duration.ofMillis(delayInMillis)).flatMap(t -> {
            if (this.isClosed) {
                logger.warn("client already closed");
                return Mono.empty();
            }
            logger.debug("startRefreshLocationTimerAsync() - Invoking refresh, I was registered on [{}]", (Object)now);
            Mono<DatabaseAccount> databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.connectionPolicy.getPreferredLocations()), this::getDatabaseAccountAsync);
            return databaseAccountObs.flatMap(dbAccount -> {
                logger.debug("db account retrieved");
                return this.refreshLocationPrivateAsync((DatabaseAccount)dbAccount);
            });
        }).onErrorResume(ex -> {
            logger.error("startRefreshLocationTimerAsync() - Unable to refresh database account from any location. Exception: {}", (Object)ex.toString(), ex);
            this.startRefreshLocationTimerAsync();
            return Mono.empty();
        }).subscribeOn(this.scheduler);
    }

    private Mono<DatabaseAccount> getDatabaseAccountAsync(URL serviceEndpoint) {
        try {
            return this.owner.getDatabaseAccountFromEndpoint(serviceEndpoint.toURI()).doOnNext(i -> logger.debug("account retrieved: {}", i)).single();
        }
        catch (URISyntaxException e) {
            return Mono.error((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

