/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ChangeFeedOptions;
import com.azure.cosmos.CommonsBridgeInternal;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.Resource;
import com.azure.cosmos.internal.OperationType;
import com.azure.cosmos.internal.ResourceType;
import com.azure.cosmos.internal.RxDocumentClientImpl;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.Strings;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.query.Paginator;
import com.azure.cosmos.internal.routing.PartitionKeyInternal;
import com.azure.cosmos.internal.routing.PartitionKeyRangeIdentity;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;

class ChangeFeedQueryImpl<T extends Resource> {
    private static final String IfNonMatchAllHeaderValue = "*";
    private final RxDocumentClientImpl client;
    private final ResourceType resourceType;
    private final Class<T> klass;
    private final String documentsLink;
    private final ChangeFeedOptions options;

    public ChangeFeedQueryImpl(RxDocumentClientImpl client, ResourceType resourceType, Class<T> klass, String collectionLink, ChangeFeedOptions changeFeedOptions) {
        this.client = client;
        this.resourceType = resourceType;
        this.klass = klass;
        this.documentsLink = Utils.joinPath(collectionLink, "docs");
        ChangeFeedOptions changeFeedOptions2 = changeFeedOptions = changeFeedOptions != null ? changeFeedOptions : new ChangeFeedOptions();
        if (resourceType.isPartitioned() && CommonsBridgeInternal.partitionKeyRangeIdInternal(changeFeedOptions) == null && changeFeedOptions.getPartitionKey() == null) {
            throw new IllegalArgumentException("One of the partition key range id or partition key must be specified");
        }
        if (changeFeedOptions.getPartitionKey() != null && !Strings.isNullOrEmpty(CommonsBridgeInternal.partitionKeyRangeIdInternal(changeFeedOptions))) {
            throw new IllegalArgumentException(String.format("Both Partition Key and Partition Key range are Specified in %s", "feedOptions"));
        }
        String initialNextIfNoneMatch = null;
        boolean canUseStartFromBeginning = true;
        if (changeFeedOptions.getRequestContinuation() != null) {
            initialNextIfNoneMatch = changeFeedOptions.getRequestContinuation();
            canUseStartFromBeginning = false;
        }
        if (changeFeedOptions.getStartDateTime() != null) {
            canUseStartFromBeginning = false;
        }
        if (canUseStartFromBeginning && !changeFeedOptions.getStartFromBeginning()) {
            initialNextIfNoneMatch = IfNonMatchAllHeaderValue;
        }
        this.options = this.getChangeFeedOptions(changeFeedOptions, initialNextIfNoneMatch);
    }

    private RxDocumentServiceRequest createDocumentServiceRequest(String continuationToken, int pageSize) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.options.getMaxItemCount() != null) {
            headers.put("x-ms-max-item-count", String.valueOf(this.options.getMaxItemCount()));
        }
        if (continuationToken != null) {
            headers.put("If-NONE-Match", continuationToken);
        }
        headers.put("A-IM", "Incremental Feed");
        if (this.options.getPartitionKey() != null) {
            PartitionKeyInternal partitionKey = this.options.getPartitionKey().getInternalPartitionKey();
            headers.put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
        if (this.options.getStartDateTime() != null) {
            String dateTimeInHttpFormat = Utils.zonedDateTimeAsUTCRFC1123(this.options.getStartDateTime());
            headers.put("If-Modified-Since", dateTimeInHttpFormat);
        }
        RxDocumentServiceRequest req = RxDocumentServiceRequest.create(OperationType.ReadFeed, this.resourceType, this.documentsLink, headers, this.options);
        if (CommonsBridgeInternal.partitionKeyRangeIdInternal(this.options) != null) {
            req.routeTo(new PartitionKeyRangeIdentity(CommonsBridgeInternal.partitionKeyRangeIdInternal(this.options)));
        }
        return req;
    }

    private ChangeFeedOptions getChangeFeedOptions(ChangeFeedOptions options, String continuationToken) {
        ChangeFeedOptions newOps = new ChangeFeedOptions(options);
        newOps.setRequestContinuation(continuationToken);
        return newOps;
    }

    public Flux<FeedResponse<T>> executeAsync() {
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = this::createDocumentServiceRequest;
        Function executeFunc = this::executeRequestAsync;
        return Paginator.getPaginatedChangeFeedQueryResultAsObservable(this.options, createRequestFunc, executeFunc, this.klass, this.options.getMaxItemCount() != null ? this.options.getMaxItemCount() : -1);
    }

    private Flux<FeedResponse<T>> executeRequestAsync(RxDocumentServiceRequest request) {
        return this.client.readFeed(request).map(rsp -> BridgeInternal.toChaneFeedResponsePage(rsp, this.klass));
    }
}

