/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosError;
import com.azure.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.cosmos.internal.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class ServiceUnavailableException
extends CosmosClientException {
    ServiceUnavailableException() {
        this("Service is currently unavailable, please retry after a while. If this problem persists please contact support.");
    }

    public ServiceUnavailableException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(503, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    ServiceUnavailableException(String message) {
        this(message, null, null, null);
    }

    ServiceUnavailableException(String message, HttpHeaders headers, String requestUriString) {
        this(message, null, headers, requestUriString);
    }

    public ServiceUnavailableException(String message, HttpHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    ServiceUnavailableException(Exception innerException) {
        this("Service is currently unavailable, please retry after a while. If this problem persists please contact support.", innerException, null, null);
    }

    public ServiceUnavailableException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(String.format("%s: %s", "Service is currently unavailable, please retry after a while. If this problem persists please contact support.", message), innerException, HttpUtils.asMap(headers), 503, requestUriString);
    }
}

