/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

public class RetryOptions {
    private int maxRetryAttemptsOnThrottledRequests = 9;
    private int maxRetryWaitTimeInSeconds = 30;

    public int getMaxRetryAttemptsOnThrottledRequests() {
        return this.maxRetryAttemptsOnThrottledRequests;
    }

    public RetryOptions setMaxRetryAttemptsOnThrottledRequests(int maxRetryAttemptsOnThrottledRequests) {
        if (maxRetryAttemptsOnThrottledRequests < 0) {
            throw new IllegalArgumentException("maxRetryAttemptsOnThrottledRequests value must be a positive integer.");
        }
        this.maxRetryAttemptsOnThrottledRequests = maxRetryAttemptsOnThrottledRequests;
        return this;
    }

    public int getMaxRetryWaitTimeInSeconds() {
        return this.maxRetryWaitTimeInSeconds;
    }

    public RetryOptions setMaxRetryWaitTimeInSeconds(int maxRetryWaitTimeInSeconds) {
        if (maxRetryWaitTimeInSeconds < 0 || maxRetryWaitTimeInSeconds > 2147483) {
            throw new IllegalArgumentException("value must be a positive integer between the range of 0 to 2147483");
        }
        this.maxRetryWaitTimeInSeconds = maxRetryWaitTimeInSeconds;
        return this;
    }

    public String toString() {
        return "RetryOptions{maxRetryAttemptsOnThrottledRequests=" + this.maxRetryAttemptsOnThrottledRequests + ", maxRetryWaitTimeInSeconds=" + this.maxRetryWaitTimeInSeconds + '}';
    }
}

