/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.DataType;
import com.azure.cosmos.Index;
import com.azure.cosmos.IndexKind;
import org.apache.commons.lang3.StringUtils;

public final class RangeIndex
extends Index {
    public RangeIndex(DataType dataType) {
        super(IndexKind.RANGE);
        this.setDataType(dataType);
    }

    public RangeIndex(DataType dataType, int precision) {
        super(IndexKind.RANGE);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    RangeIndex(String jsonString) {
        super(jsonString, IndexKind.RANGE);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase((String)super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public RangeIndex setDataType(DataType dataType) {
        super.set("dataType", dataType.toString());
        return this;
    }

    public int getPrecision() {
        return super.getInt("precision");
    }

    public RangeIndex setPrecision(int precision) {
        super.set("precision", precision);
        return this;
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

