/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosError;
import com.azure.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.cosmos.internal.http.HttpHeaders;
import java.util.Map;

public class PartitionIsMigratingException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    public PartitionIsMigratingException() {
        this("The requested resource is no longer available at the server.");
    }

    public PartitionIsMigratingException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    PartitionIsMigratingException(String msg) {
        super(410, msg);
        this.setSubStatus();
    }

    PartitionIsMigratingException(String msg, String resourceAddress) {
        super(msg, null, null, 410, resourceAddress);
        this.setSubStatus();
    }

    public PartitionIsMigratingException(String message, HttpHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    PartitionIsMigratingException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, null, null);
    }

    PartitionIsMigratingException(String message, Exception innerException, HttpHeaders headers, String requestUri) {
        super(String.format("%s: %s", "The requested resource is no longer available at the server.", message), innerException, HttpUtils.asMap(headers), 410, requestUri);
        this.setSubStatus();
    }

    private void setSubStatus() {
        this.getResponseHeaders().put("x-ms-substatus", Integer.toString(1008));
    }
}

