/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyPolicy;
import com.azure.cosmos.DatabaseAccountLocation;
import com.azure.cosmos.Resource;
import com.azure.cosmos.internal.ReplicationPolicy;
import com.azure.cosmos.internal.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DatabaseAccount
extends Resource {
    private ConsistencyPolicy consistencyPolicy;
    private long maxMediaStorageUsageInMB;
    private long mediaStorageUsageInMB;
    private ReplicationPolicy replicationPolicy;
    private ReplicationPolicy systemReplicationPolicy;
    private Map<String, Object> queryEngineConfiguration;

    public DatabaseAccount() {
        BridgeInternal.setResourceSelfLink(this, "");
    }

    public DatabaseAccount(String jsonString) {
        super(jsonString);
    }

    String getDatabasesLink() {
        return super.getString("_dbs");
    }

    void setDatabasesLink(String databasesLink) {
        BridgeInternal.setProperty(this, "_dbs", databasesLink);
    }

    String getMediaLink() {
        return super.getString("media");
    }

    void setMediaLink(String medialink) {
        BridgeInternal.setProperty(this, "media", medialink);
    }

    String getAddressesLink() {
        return super.getString("addresses");
    }

    void setAddressesLink(String addresseslink) {
        BridgeInternal.setProperty(this, "addresses", addresseslink);
    }

    long getMaxMediaStorageUsageInMB() {
        return this.maxMediaStorageUsageInMB;
    }

    void setMaxMediaStorageUsageInMB(long value) {
        this.maxMediaStorageUsageInMB = value;
    }

    long getMediaStorageUsageInMB() {
        return this.mediaStorageUsageInMB;
    }

    void setMediaStorageUsageInMB(long value) {
        this.mediaStorageUsageInMB = value;
    }

    ConsistencyPolicy getConsistencyPolicy() {
        if (this.consistencyPolicy == null) {
            this.consistencyPolicy = super.getObject("userConsistencyPolicy", ConsistencyPolicy.class, new boolean[0]);
            if (this.consistencyPolicy == null) {
                this.consistencyPolicy = new ConsistencyPolicy();
            }
        }
        return this.consistencyPolicy;
    }

    ReplicationPolicy getReplicationPolicy() {
        if (this.replicationPolicy == null) {
            this.replicationPolicy = super.getObject("userReplicationPolicy", ReplicationPolicy.class, new boolean[0]);
            if (this.replicationPolicy == null) {
                this.replicationPolicy = new ReplicationPolicy();
            }
        }
        return this.replicationPolicy;
    }

    ReplicationPolicy getSystemReplicationPolicy() {
        if (this.systemReplicationPolicy == null) {
            this.systemReplicationPolicy = super.getObject("systemReplicationPolicy", ReplicationPolicy.class, new boolean[0]);
            if (this.systemReplicationPolicy == null) {
                this.systemReplicationPolicy = new ReplicationPolicy();
            }
        }
        return this.systemReplicationPolicy;
    }

    Map<String, Object> getQueryEngineConfiguration() {
        String queryEngineConfigurationJsonString;
        if (this.queryEngineConfiguration == null && StringUtils.isNotEmpty((CharSequence)(queryEngineConfigurationJsonString = super.getObject("queryEngineConfiguration", String.class, new boolean[0])))) {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            try {
                this.queryEngineConfiguration = (Map)Utils.getSimpleObjectMapper().readValue(queryEngineConfigurationJsonString, (TypeReference)typeRef);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            if (this.queryEngineConfiguration == null) {
                this.queryEngineConfiguration = new HashMap<String, Object>();
            }
        }
        return this.queryEngineConfiguration;
    }

    public Iterable<DatabaseAccountLocation> getWritableLocations() {
        return super.getCollection("writableLocations", DatabaseAccountLocation.class, new boolean[0]);
    }

    void setWritableLocations(Iterable<DatabaseAccountLocation> locations) {
        BridgeInternal.setProperty(this, "writableLocations", locations);
    }

    public Iterable<DatabaseAccountLocation> getReadableLocations() {
        return super.getCollection("readableLocations", DatabaseAccountLocation.class, new boolean[0]);
    }

    void setReadableLocations(Iterable<DatabaseAccountLocation> locations) {
        BridgeInternal.setProperty(this, "readableLocations", locations);
    }

    public boolean getEnableMultipleWriteLocations() {
        return (Boolean)ObjectUtils.defaultIfNull((Object)super.getBoolean("enableMultipleWriteLocations"), (Object)false);
    }

    void setEnableMultipleWriteLocations(boolean value) {
        BridgeInternal.setProperty(this, "enableMultipleWriteLocations", value);
    }

    @Override
    void populatePropertyBag() {
        if (this.consistencyPolicy != null) {
            BridgeInternal.populatePropertyBagJsonSerializable(this.consistencyPolicy);
            BridgeInternal.setProperty(this, "userConsistencyPolicy", this.consistencyPolicy);
        }
    }

    @Override
    public String toJson() {
        this.populatePropertyBag();
        return super.toJson();
    }
}

