/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.Resource;
import com.azure.cosmos.TriggerOperation;
import com.azure.cosmos.TriggerType;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.Trigger;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CosmosTriggerProperties
extends Resource {
    public CosmosTriggerProperties() {
    }

    CosmosTriggerProperties(String jsonString) {
        super(jsonString);
    }

    CosmosTriggerProperties(ResourceResponse<Trigger> response) {
        super(response.getResource().toJson());
    }

    @Override
    public CosmosTriggerProperties setId(String id) {
        super.setId(id);
        return this;
    }

    public String getBody() {
        return super.getString("body");
    }

    public CosmosTriggerProperties setBody(String body) {
        super.set("body", body);
        return this;
    }

    public TriggerType getTriggerType() {
        TriggerType result = TriggerType.PRE;
        try {
            result = TriggerType.valueOf(StringUtils.upperCase((String)super.getString("triggerType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID triggerType value {}.", (Object)super.getString("triggerType"));
        }
        return result;
    }

    public CosmosTriggerProperties setTriggerType(TriggerType triggerType) {
        super.set("triggerType", triggerType.toString());
        return this;
    }

    public TriggerOperation getTriggerOperation() {
        TriggerOperation result = TriggerOperation.CREATE;
        try {
            result = TriggerOperation.valueOf(StringUtils.upperCase((String)super.getString("triggerOperation")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID triggerOperation value {}.", (Object)super.getString("triggerOperation"));
        }
        return result;
    }

    public CosmosTriggerProperties setTriggerOperation(TriggerOperation triggerOperation) {
        super.set("triggerOperation", triggerOperation.toString());
        return this;
    }

    static List<CosmosTriggerProperties> getFromV2Results(List<Trigger> results) {
        return results.stream().map(trigger -> new CosmosTriggerProperties(trigger.toJson())).collect(Collectors.toList());
    }
}

