/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosStoredProcedureProperties;
import com.azure.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.CosmosStoredProcedureResponse;

public class CosmosStoredProcedure {
    private final String id;
    private final CosmosContainer container;
    private final CosmosAsyncStoredProcedure storedProcedure;

    public CosmosStoredProcedure(String id, CosmosContainer container, CosmosAsyncStoredProcedure storedProcedure) {
        this.id = id;
        this.container = container;
        this.storedProcedure = storedProcedure;
    }

    public String getId() {
        return this.id;
    }

    public CosmosStoredProcedureResponse read() throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.read());
    }

    public CosmosStoredProcedureResponse read(CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.read(options));
    }

    public CosmosStoredProcedureResponse delete() throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.delete());
    }

    CosmosStoredProcedureResponse delete(CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.delete(options));
    }

    public CosmosStoredProcedureResponse execute(Object[] procedureParams, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.execute(procedureParams, options));
    }

    public CosmosStoredProcedureResponse replace(CosmosStoredProcedureProperties storedProcedureSettings) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.replace(storedProcedureSettings));
    }

    public CosmosStoredProcedureResponse replace(CosmosStoredProcedureProperties storedProcedureSettings, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.container.getScripts().mapStoredProcedureResponseAndBlock(this.storedProcedure.replace(storedProcedureSettings, options));
    }
}

