/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.AccessCondition;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.IndexingDirective;
import com.azure.cosmos.PartitionKey;
import com.azure.cosmos.internal.RequestOptions;
import java.util.List;

public class CosmosItemRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private IndexingDirective indexingDirective;
    private List<String> preTriggerInclude;
    private List<String> postTriggerInclude;
    private String sessionToken;
    private PartitionKey partitionKey;
    private AccessCondition accessCondition;

    public CosmosItemRequestOptions() {
    }

    public CosmosItemRequestOptions(Object partitionKey) {
        if (partitionKey instanceof PartitionKey) {
            this.setPartitionKey((PartitionKey)partitionKey);
        } else {
            this.setPartitionKey(new PartitionKey(partitionKey));
        }
    }

    public AccessCondition getAccessCondition() {
        return this.accessCondition;
    }

    public CosmosItemRequestOptions setAccessCondition(AccessCondition accessCondition) {
        this.accessCondition = accessCondition;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosItemRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public IndexingDirective getIndexingDirective() {
        return this.indexingDirective;
    }

    public CosmosItemRequestOptions setIndexingDirective(IndexingDirective indexingDirective) {
        this.indexingDirective = indexingDirective;
        return this;
    }

    public List<String> getPreTriggerInclude() {
        return this.preTriggerInclude;
    }

    public CosmosItemRequestOptions setPreTriggerInclude(List<String> preTriggerInclude) {
        this.preTriggerInclude = preTriggerInclude;
        return this;
    }

    public List<String> getPostTriggerInclude() {
        return this.postTriggerInclude;
    }

    public CosmosItemRequestOptions setPostTriggerInclude(List<String> postTriggerInclude) {
        this.postTriggerInclude = postTriggerInclude;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosItemRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public CosmosItemRequestOptions setPartitionKey(PartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setAccessCondition(this.accessCondition);
        requestOptions.setAccessCondition(this.getAccessCondition());
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setIndexingDirective(this.indexingDirective);
        requestOptions.setPreTriggerInclude(this.preTriggerInclude);
        requestOptions.setPostTriggerInclude(this.postTriggerInclude);
        requestOptions.setSessionToken(this.sessionToken);
        requestOptions.setPartitionKey(this.partitionKey);
        return requestOptions;
    }
}

