/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncItem;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.CosmosItemResponse;

public class CosmosItem {
    private final CosmosContainer container;
    private final CosmosAsyncItem asyncItem;
    private final String id;
    private final Object partitionKey;

    CosmosItem(String id, Object partitionKey, CosmosContainer cosmosContainer, CosmosAsyncItem item) {
        this.id = id;
        this.partitionKey = partitionKey;
        this.container = cosmosContainer;
        this.asyncItem = item;
    }

    public String getId() {
        return this.id;
    }

    public Object getPartitionKey() {
        return this.partitionKey;
    }

    public CosmosItemResponse read(CosmosItemRequestOptions options) throws CosmosClientException {
        return this.container.mapItemResponseAndBlock(this.asyncItem.read(options));
    }

    public CosmosItemResponse replace(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.container.mapItemResponseAndBlock(this.asyncItem.replace(item, options));
    }

    public CosmosItemResponse delete(CosmosItemRequestOptions options) throws CosmosClientException {
        return this.container.mapItemResponseAndBlock(this.asyncItem.delete(options));
    }
}

