/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainerResponse;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncUserResponse;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosContainerResponse;
import com.azure.cosmos.CosmosDatabaseRequestOptions;
import com.azure.cosmos.CosmosDatabaseResponse;
import com.azure.cosmos.CosmosUser;
import com.azure.cosmos.CosmosUserProperties;
import com.azure.cosmos.CosmosUserResponse;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosDatabase {
    private final CosmosAsyncDatabase databaseWrapper;
    private final CosmosClient client;
    private final String id;

    CosmosDatabase(String id, CosmosClient client, CosmosAsyncDatabase database) {
        this.id = id;
        this.client = client;
        this.databaseWrapper = database;
    }

    public String getId() {
        return this.id;
    }

    public CosmosDatabaseResponse read() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read());
    }

    public CosmosDatabaseResponse read(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read(options));
    }

    public CosmosDatabaseResponse delete() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete());
    }

    public CosmosDatabaseResponse delete(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete(options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput, options));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath, throughput));
    }

    CosmosContainerResponse mapContainerResponseAndBlock(Mono<CosmosAsyncContainerResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosContainerResponse)containerMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> readAllContainers(FeedOptions options) {
        return this.databaseWrapper.readAllContainers(options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> readAllContainers() {
        return this.databaseWrapper.readAllContainers().toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(String query) {
        return this.databaseWrapper.queryContainers(query).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(String query, FeedOptions options) {
        return this.databaseWrapper.queryContainers(query, options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec) {
        return this.databaseWrapper.queryContainers(querySpec).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.databaseWrapper.queryContainers(querySpec, options).toIterable().iterator();
    }

    public CosmosContainer getContainer(String id) {
        return new CosmosContainer(id, this, this.databaseWrapper.getContainer(id));
    }

    CosmosContainerResponse convertResponse(CosmosAsyncContainerResponse response) {
        return new CosmosContainerResponse(response, this, this.client);
    }

    public CosmosUserResponse createUser(CosmosUserProperties settings) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.createUser(settings));
    }

    public CosmosUserResponse upsertUser(CosmosUserProperties settings) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.upsertUser(settings));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> readAllUsers() {
        return this.getFeedIterator(this.databaseWrapper.readAllUsers());
    }

    public Iterator<FeedResponse<CosmosUserProperties>> readAllUsers(FeedOptions options) {
        return this.getFeedIterator(this.databaseWrapper.readAllUsers(options));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(String query) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(query));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(String query, FeedOptions options) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(query, options));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(querySpec));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(querySpec, options));
    }

    public CosmosUser getUser(String id) {
        return new CosmosUser(this.databaseWrapper.getUser(id), this, id);
    }

    CosmosUserResponse mapUserResponseAndBlock(Mono<CosmosAsyncUserResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosUserResponse)containerMono.map(this::convertUserResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    private CosmosUserResponse convertUserResponse(CosmosAsyncUserResponse response) {
        return new CosmosUserResponse(response, this);
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return CosmosDatabase.throughputResponseToBlock(this.databaseWrapper.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return CosmosDatabase.throughputResponseToBlock(this.databaseWrapper.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    static Integer throughputResponseToBlock(Mono<Integer> throughputResponse) throws CosmosClientException {
        try {
            return (Integer)throughputResponse.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    private <T> Iterator<FeedResponse<T>> getFeedIterator(Flux<FeedResponse<T>> itemFlux) {
        return itemFlux.toIterable(1).iterator();
    }
}

