/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncUserDefinedFunctionResponse;
import com.azure.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.UserDefinedFunction;
import reactor.core.publisher.Mono;

public class CosmosAsyncUserDefinedFunction {
    private CosmosAsyncContainer container;
    private String id;

    CosmosAsyncUserDefinedFunction(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUserDefinedFunction setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> read() {
        return this.container.getDatabase().getDocClientWrapper().readUserDefinedFunction(this.getLink(), null).map(response -> new CosmosAsyncUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> replace(CosmosUserDefinedFunctionProperties udfSettings) {
        return this.container.getDatabase().getDocClientWrapper().replaceUserDefinedFunction(new UserDefinedFunction(udfSettings.toJson()), null).map(response -> new CosmosAsyncUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> delete() {
        return this.container.getDatabase().getDocClientWrapper().deleteUserDefinedFunction(this.getLink(), null).map(response -> new CosmosAsyncUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    String URIPathSegment() {
        return "udfs";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

