/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncPermission;
import com.azure.cosmos.CosmosAsyncPermissionResponse;
import com.azure.cosmos.CosmosAsyncUserResponse;
import com.azure.cosmos.CosmosPermissionProperties;
import com.azure.cosmos.CosmosPermissionRequestOptions;
import com.azure.cosmos.CosmosUserProperties;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.internal.Permission;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.User;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncUser {
    CosmosAsyncDatabase database;
    private String id;

    CosmosAsyncUser(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUser setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncUserResponse> read() {
        return this.database.getDocClientWrapper().readUser(this.getLink(), null).map(response -> new CosmosAsyncUserResponse((ResourceResponse<User>)response, this.database)).single();
    }

    public Mono<CosmosAsyncUserResponse> replace(CosmosUserProperties userSettings) {
        return this.database.getDocClientWrapper().replaceUser(userSettings.getV2User(), null).map(response -> new CosmosAsyncUserResponse((ResourceResponse<User>)response, this.database)).single();
    }

    public Mono<CosmosAsyncUserResponse> delete() {
        return this.database.getDocClientWrapper().deleteUser(this.getLink(), null).map(response -> new CosmosAsyncUserResponse((ResourceResponse<User>)response, this.database)).single();
    }

    public Mono<CosmosAsyncPermissionResponse> createPermission(CosmosPermissionProperties permissionSettings, CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        Permission permission = permissionSettings.getV2Permissions();
        return this.database.getDocClientWrapper().createPermission(this.getLink(), permission, options.toRequestOptions()).map(response -> new CosmosAsyncPermissionResponse((ResourceResponse<Permission>)response, this)).single();
    }

    public Mono<CosmosAsyncPermissionResponse> upsertPermission(CosmosPermissionProperties permissionSettings, CosmosPermissionRequestOptions options) {
        Permission permission = permissionSettings.getV2Permissions();
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.database.getDocClientWrapper().upsertPermission(this.getLink(), permission, options.toRequestOptions()).map(response -> new CosmosAsyncPermissionResponse((ResourceResponse<Permission>)response, this)).single();
    }

    public Flux<FeedResponse<CosmosPermissionProperties>> readAllPermissions(FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().readPermissions(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosPermissionProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosPermissionProperties>> queryPermissions(String query) {
        return this.queryPermissions(query);
    }

    public Flux<FeedResponse<CosmosPermissionProperties>> queryPermissions(String query, FeedOptions options) {
        return this.getDatabase().getDocClientWrapper().queryPermissions(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(CosmosPermissionProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncPermission getPermission(String id) {
        return new CosmosAsyncPermission(id, this);
    }

    String URIPathSegment() {
        return "users";
    }

    String parentLink() {
        return this.database.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }
}

