/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncTriggerResponse;
import com.azure.cosmos.CosmosTriggerProperties;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.Trigger;
import reactor.core.publisher.Mono;

public class CosmosAsyncTrigger {
    private CosmosAsyncContainer container;
    private String id;

    CosmosAsyncTrigger(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncTrigger setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncTriggerResponse> read() {
        return this.container.getDatabase().getDocClientWrapper().readTrigger(this.getLink(), null).map(response -> new CosmosAsyncTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    public Mono<CosmosAsyncTriggerResponse> replace(CosmosTriggerProperties triggerSettings) {
        return this.container.getDatabase().getDocClientWrapper().replaceTrigger(new Trigger(triggerSettings.toJson()), null).map(response -> new CosmosAsyncTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    public Mono<CosmosAsyncTriggerResponse> delete() {
        return this.container.getDatabase().getDocClientWrapper().deleteTrigger(this.getLink(), null).map(response -> new CosmosAsyncTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    String URIPathSegment() {
        return "triggers";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

