/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.CosmosStoredProcedureProperties;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.StoredProcedure;
import com.azure.cosmos.internal.StoredProcedureResponse;

public class CosmosAsyncStoredProcedureResponse
extends CosmosResponse<CosmosStoredProcedureProperties> {
    private CosmosAsyncStoredProcedure storedProcedure;
    private StoredProcedureResponse storedProcedureResponse;

    CosmosAsyncStoredProcedureResponse(ResourceResponse<StoredProcedure> response, CosmosAsyncContainer cosmosContainer) {
        super(response);
        if (response.getResource() != null) {
            super.setProperties(new CosmosStoredProcedureProperties(response));
            this.storedProcedure = new CosmosAsyncStoredProcedure(this.getProperties().getId(), cosmosContainer);
        }
    }

    CosmosAsyncStoredProcedureResponse(StoredProcedureResponse response, CosmosAsyncContainer cosmosContainer) {
        super(response);
        this.storedProcedureResponse = response;
    }

    @Override
    public CosmosStoredProcedureProperties getProperties() {
        return (CosmosStoredProcedureProperties)super.getProperties();
    }

    public CosmosAsyncStoredProcedure getStoredProcedure() {
        return this.storedProcedure;
    }

    @Override
    public String getActivityId() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getActivityId();
        }
        return super.getActivityId();
    }

    @Override
    public String getSessionToken() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getSessionToken();
        }
        return super.getSessionToken();
    }

    @Override
    public int getStatusCode() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getStatusCode();
        }
        return super.getStatusCode();
    }

    @Override
    public double getRequestCharge() {
        if (this.storedProcedureResponse != null) {
            return this.storedProcedureResponse.getRequestCharge();
        }
        return super.getRequestCharge();
    }

    public String getResponseAsString() {
        return this.storedProcedureResponse.getResponseAsString();
    }

    public String getScriptLog() {
        return this.storedProcedureResponse.getScriptLog();
    }
}

