/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncStoredProcedureResponse;
import com.azure.cosmos.CosmosStoredProcedureProperties;
import com.azure.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.StoredProcedure;
import com.azure.cosmos.internal.StoredProcedureResponse;
import reactor.core.publisher.Mono;

public class CosmosAsyncStoredProcedure {
    private CosmosAsyncContainer cosmosContainer;
    private String id;

    CosmosAsyncStoredProcedure(String id, CosmosAsyncContainer cosmosContainer) {
        this.id = id;
        this.cosmosContainer = cosmosContainer;
    }

    public String id() {
        return this.id;
    }

    CosmosAsyncStoredProcedure id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncStoredProcedureResponse> read() {
        return this.read(null);
    }

    public Mono<CosmosAsyncStoredProcedureResponse> read(CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().readStoredProcedure(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.cosmosContainer)).single();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> delete() {
        return this.delete(null);
    }

    public Mono<CosmosAsyncStoredProcedureResponse> delete(CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().deleteStoredProcedure(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.cosmosContainer)).single();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> execute(Object[] procedureParams, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().executeStoredProcedure(this.getLink(), options.toRequestOptions(), procedureParams).map(response -> new CosmosAsyncStoredProcedureResponse((StoredProcedureResponse)response, this.cosmosContainer)).single();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureSettings) {
        return this.replace(storedProcedureSettings, null);
    }

    public Mono<CosmosAsyncStoredProcedureResponse> replace(CosmosStoredProcedureProperties storedProcedureSettings, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        return this.cosmosContainer.getDatabase().getDocClientWrapper().replaceStoredProcedure(new StoredProcedure(storedProcedureSettings.toJson()), options.toRequestOptions()).map(response -> new CosmosAsyncStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.cosmosContainer)).single();
    }

    String URIPathSegment() {
        return "sprocs";
    }

    String parentLink() {
        return this.cosmosContainer.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

